% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galilean_satellites.R
\name{galsat_animate}
\alias{galsat_animate}
\title{Animate the motion of Jupiter's Galilean satellites}
\usage{
galsat_animate(
  year,
  month,
  day,
  hour,
  minute,
  duration_hours = 24,
  time_step_minutes = 5,
  pause_seconds = 0.05
)
}
\arguments{
\item{year}{Type in the starting year (integer number from 0 to 3000).}

\item{month}{Type in the starting month (integer number from 1 to 12).}

\item{day}{Type in the starting day (integer number from 1 to 31).}

\item{hour}{Type in the starting hour (integer number from 0 to 23).}

\item{minute}{Type in the starting minute (integer number from 0 to 59).}

\item{duration_hours}{Duration of the animation in hours (default 24).}

\item{time_step_minutes}{Time step between frames in minutes (default 5).}

\item{pause_seconds}{Pause between frames in seconds (default 0.05).}
}
\value{
Creates an animated plot showing the orbital motion of Jupiter's moons.
Returns invisibly the final positions data frame.
}
\description{
\code{galsat_animate()} creates an animation showing the orbital motion of Jupiter's
four largest satellites over time. The function starts from a user-specified
time and advances in regular intervals to show how the moons move around Jupiter.
}
\details{
The animation uses the galsat() function internally to calculate satellite
positions at each time step. Time is advanced by the specified interval
(default 5 minutes) for each frame of the animation.
}
\examples{
# Animate 2 hours with 10-minutes steps
galsat_animate(2025, 10, 6, 21, 50, duration_hours = 2, time_step_minutes = 10)
}
