% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_gofCOP_plot.R
\name{plot.gofCOP}
\alias{plot.gofCOP}
\title{Plotting function for objects of class gofCOP}
\usage{
\method{plot}{gofCOP}(
  x,
  copula = NULL,
  hybrid = NULL,
  point.bg = "white",
  point.col = "black",
  point.cex = 0.7,
  jitter.val = 0.1,
  pal = "xmen",
  bean.b.o = 0.2,
  inf.method = "hdi",
  theme = 2,
  ...
)
}
\arguments{
\item{x}{An object of \code{class} gofCOP.}

\item{copula}{Specify for which copulae to plot the results. The possible
entry is a character vector of the copula names. Default is \code{NULL}
which plots all copulae in the object.}

\item{hybrid}{Specify for which combinations to plot the hybrid tests. The
possible entry is a numeric vector of the hybrid combinations. Default is
\code{NULL} which plots all possible combinations.}

\item{point.bg}{The background color of the plot. Defaults to \code{white}.}

\item{point.col}{The color of the dots. Defaults to \code{black}.}

\item{point.cex}{The size of the dots. Defaults to \code{0.7}.}

\item{jitter.val}{Jittering the dots left/right for better visibility of
results. Defaults to \code{0.1}.}

\item{pal}{Color palette of the plots. Defaults to \code{xmen}.}

\item{bean.b.o}{Specification of how opaque the bars are. Defaults to
\code{0.2}.}

\item{inf.method}{Type of inference bands. Defaults to Bayesian Highest
Density Intervals, \code{hdi}.}

\item{theme}{Theme of the plot. See \code{\link[yarrr]{pirateplot}} for more
details. Defaults to \code{2}.}

\item{...}{Further arguments to be passed to \code{\link[yarrr]{pirateplot}}.}
}
\value{
None
}
\description{
Plots an object of class gofCOP.
}
\details{
The plotting function is constructed around \code{\link[yarrr]{pirateplot}} from
the \code{yarrr} package. Please see respective package for more details on
the non-default specifications of the plotting function.

We recommend not to amend the arguments \code{xlim}, \code{data},
\code{formula}, \code{sortx}, \code{xaxt}, \code{ylim} and \code{ylab} from
\code{\link[yarrr]{pirateplot}}. The arguments were defined such that the resulting
plot displays the test results in a proper manner.
}
\references{
Phillips, N. (2017). yarrr: A Companion to the e-Book "YaRrr!:
The Pirate's Guide to R". \emph{R package version 0.1.5.}
\url{https://CRAN.R-project.org/package=yarrr} \cr \cr
}
