% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-grafos-TSP.R
\encoding{UTF-8}
\name{compute_tour_distance}
\alias{compute_tour_distance}
\title{Compute the distance of a TSP tour}
\usage{
compute_tour_distance(h, d)
}
\arguments{
\item{h}{A tour specified by a vertex sequence}

\item{d}{Distance matrix to use}
}
\value{
The tour distance \deqn{d(\{v_1,...,v_n\}) = \sum_{j=1}^n
    d(v_j,v_{(j mod n) + 1}).}
}
\description{
It computes the distance covered by a tour in a Traveling Salesman Problem
}
\details{
This function simply add the distances in a distance matrix
indicated by a vertex sequence defining a tour.  It takes into
account that, in a tour, the last vertex is joined to the
first one by an edge, and adds its distance to the result,
unlike \link{compute_path_distance}.
}
\examples{
set.seed(1)
n <- 25
z <- cbind(runif(n,min=1,max=10),runif(n,min=1,max=10))
d <- compute_distance_matrix(z)
h <- sample(1:n)              # A random tour
compute_tour_distance(h, d)   # 114.58

}
\seealso{
\link{build_tour_nn} nearest neighbor heuristic with a single
starting point, \link{build_tour_nn_best} repeats the previous
algorithm with all possible starting points,
\link{compute_distance_matrix} computes a distance matrix,
\link{compute_path_distance} computes path distances, \link{plot_tour}
plots a tour.
}
\author{
Cesar Asensio
}
