% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hothiphop.R
\name{hothiphop}
\alias{hothiphop}
\title{A function that calculates the genetic mismatches according to the hiphop and hot
test}
\source{
Cockburn et al. (2020) HIPHOP: improved paternity assignment among
close relatives using a simple exclusion method for biallelic markers.
Molecular Ecology Resources, in revision.
}
\usage{
hothiphop(ind, gen)
}
\arguments{
\item{ind}{The input file with individuals, which should contain at least the columns
brood, individual, type, social.parent, year.}

\item{gen}{The input file with genotypes, which should contain the loci-names as column headers
and the individual  names as row-header and should only contain the values 0, 1, 2 or NA.}
}
\value{
a dataframe with all possible  offspring-potential.dam-potential.sire combinations
and their mismatch scores according to the HOT and HIPHOP test, the number of loci this was based on,
and some additional relevant information about the social parents and potential dam and sires
\describe{
\item{year}{ the year or cohort that is being considered, adults can be potential dam or sire in some years, but no in others}
\item{brood}{ an identifier of the brood to which the offspring and adults belong/are associated with}
\item{offspring}{ an identifier of the offspring }
\item{potential.dam}{ an identifier of the potential dam }
\item{potential.sire}{ an identifier of the potential sire }
\item{hothiphop.parents}{ the sum of the hiphop and hot.parents mismatch score }
\item{hiphop}{ the hiphop mismatch score of the offspring with the potential dam and potential sire, expressed as the number of loci giving mismatches }
\item{hot.parents}{ the hot score of the offspring with both the potential dam and sire, expressed as the number of loci giving mismatches}
\item{hot.dam}{ the hot score of the offspring with the potential dam, expressed as the number of loci giving mismatches}
\item{hot.sire}{ the hot mismatch score of the offspring with the potential sire , expressed as the number of loci giving mismatches}
\item{hothiphop.dam}{ the sum of the hot.dam and hiphop mismatch score }
\item{hothiphop.sire}{ the sum of the hot.sire and hiphop mismatch score }
\item{loci.dyad.dam}{ the number of loci at which both the offspring and dam were not NA }
\item{loci.dyad.sire}{the number of loci at which both the offspring and sire were not NA }
\item{loci.triad}{ the number of loci at which the offspring, dam and sire were not NA }
\item{offspring.heterozygosity}{ proportion of loci at which the offspring was heterozygous }
\item{social.mother.sampled}{if the social.mother genotypic data is in the genotypes file then equal to 1, else 0}
\item{social.father.sampled}{if the social.father genotypic data is in the genotypes file then equal to 1, else 0}
\item{is.dam.social}{if the potential dam is the social mother then equal to 1, else 0}
\item{is.sire.social}{if the potential sire is the social father then equal to 1, else 0}
\item{is.dam.within.group}{if the potential dam is part of the same group (i.e. associated with the same brood) as the offspring, then equal to 1, else 0}
\item{is.sire.within.group}{if the potential sire is part of the same group (i.e. associated with the same brood) as the offspring, then equal to 1, else 0}
\item{social.mother}{ identity of the social mother of the offspring}
\item{social.father}{ identity of the social father of the offspring}
}
}
\description{
This function  calculates the number genetic mismatches according to the hiphop and hot
test for any combination of offspring-potential.dam-potential.sire.
The HOT test (Homozygous Opposite Test; Huisman 2017) compares the genotype of an offspring with a potential parent:
a mismatch is scored when both the offspring and parent are homozygous, but for different alleles.
The HIPHOP test (Homozygous Identical Parents, Heterozygous Offspring are Precluded; Cockburn et al. in revision)
compares the genotype of an offspring with both potential parents:
a mismatch is scored when the offspring is heterozygous and both parent are homozygous for the same allele
The resulting output can next be summarized using the 'topmatch()' function.
}
\examples{
results<-hothiphop(ind=individuals[1:22,], gen=genotypes)
head(results)
best<-topmatch(x=results, ranking="hothiphop.parents")
head(best)
}
\references{
Cockburn et al. (2020) HIPHOP: improved paternity assignment among close relatives using a simple exclusion method for biallelic markers.
Molecular Ecology Resources, in revision.

Huisman, J. (2017). Pedigree reconstruction from SNP data: parentage assignment, sibship clustering and beyond. Molecular ecology resources, 17(5), 1009-1024.
}
\author{
Martijn van de Pol, \email{martijn@myscience.eu}
}
