% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{inspect}
\alias{inspect}
\title{A function that inspects the genotypes of individuals}
\usage{
inspect(ind, gen)
}
\arguments{
\item{ind}{The input file with individuals, which should contain at least the columns
brood, individual, type, social.parent, year.}

\item{gen}{The input file with genotypes, which should contain the loci-names as column headers
and the individual  names as row-header and should only contain the values 0, 1, 2 or NA.}
}
\value{
the individuals file with a summary of the genotypes attached.
#' \describe{
\item{brood}{ an identifier of the brood to which the offspring and adults belong/are associated with}
\item{individual}{ an identifier of the offspring }
\item{type}{ denotes whether the individual is an offspring, adult female (potential dam) or adult male (potential sire)}
\item{social.parent}{ if the individual is the social parent of the brood then equal to 1, else 0}
\item{year}{ the year or cohort that is being considered, adults can be potential dam or sire in some years, but no in others}
\item{sampled}{if the individual's genotypic data is in the genotypes file then equal to 1, else 0}
\item{homozygote.0}{ the proportion of loci that was scored as 0 (homozygotes at common allele) }
\item{homozygote.1}{ the proportion of loci that was scored as 1 (homozygotes at rare allele) }
\item{homozygote.2}{ the proportion of loci that was scored as 2 (heterozygote) }
\item{missing}{ the proportion of loci that has missing values (NA) }
\item{number.loci}{ the number of loci that has genotypic information  (i.e. not NA) }
}
}
\description{
This function allows one to inspect the genotypes of all individuals in your input file to see
whether genetic data is available, and if so what the proportion of
homozygotes, heterozygotes fraction of missing values is.
}
\examples{
overview<-inspect(ind=individuals[1:22,], gen=genotypes)
head(overview)
}
\author{
Martijn van de Pol, \email{martijn@myscience.eu}
}
