% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redact.R
\name{as.redactor}
\alias{as.redactor}
\title{Wrap a redacting expression as a proper function}
\usage{
as.redactor(fmla)
}
\arguments{
\item{fmla}{Partial expression (a \code{formula}) to turn into a function}
}
\value{
A \code{function}.
}
\description{
Redactors take a \code{response} as their first argument, and some take additional
arguments: \code{redact_headers()}, for example, requires that you specify
\code{headers}. This function allows you to take a simplified expression via a
formula, similar to what \code{purrr} does, so that you can provide the function
to \code{capture_requests()}.
}
\details{
For example, \code{as.redactor(~ redact_headers(., "X-Custom-Header"))} is equivalent
to \code{function (response) redact_headers(response, "X-Custom-Header")}. This
allows you to do
\code{set_redactor(~ redact_headers(., "X-Custom-Header"))}.
}
\seealso{
\code{\link[=capture_requests]{capture_requests()}}
}
\keyword{internal}
