% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventPOT.R
\name{eventPOT}
\alias{eventPOT}
\title{Event identification (using a peak over threshold algorithm)}
\usage{
eventPOT(data, threshold = 0, min.diff = 1, out.style = "summary")
}
\arguments{
\item{data}{A data vector}

\item{threshold}{Value above which an event is considered to have occurred}

\item{min.diff}{Spacing required for two events to be considered separate}

\item{out.style}{The type of output (currently either "summary" or "none")}
}
\value{
By default, the \code{out.style} returns the indices of the maximum in each event, as well as the value of
the maximum and the sum of the \code{data} in each event, alongside the start and end of the events. Otherwise just
the indices of start and end of events as a two column dataframe are returned.
}
\description{
Identify events using a specified threshold value over which an event is considered to have occurred.
}
\details{
The \code{threshold} can be thought of a value below which the \code{data} are considered to be "zero".
The \code{min.diff} can be viewed as the minimum spacing for event independence.
}
\examples{
# Example using streamflow data
bf = baseflowB(dataBassRiver, alpha = 0.925)
qf = dataBassRiver - bf$bf
events = eventPOT(qf)
plotEvents(qf, dates = NULL, events = events, type = "lineover",
   main = "Events (plotted on quickflow)")
plotEvents(dataBassRiver, dates = NULL, events = events, type = "lineover",
   main = "Events (plotted on streamflow)")

# Examples using rainfall data
events = eventPOT(dataLoch, threshold = 0, min.diff = 1)
plotEvents(dataLoch, dates = NULL, events = events, type = "hyet",
   main = "Rainfall Events (threshold = 0, min.diff = 1)")

events = eventPOT(dataLoch, threshold = 2, min.diff = 2)
plotEvents(dataLoch, dates = NULL, events = events, type = "hyet",
   main = "Rainfall Events (threshold = 2, min.diff = 2)")
}
\references{
  Wasko, C. & Guo, D. (2022) Understanding event runoff coefficient variability across Australia using the hydroEvents R package. Hydrological Processes <doi:10.1002/hyp.14563>.
}
\seealso{
\code{\link{calcStats}} \code{\link{eventBaseflow}} \code{\link{eventMaxima}} \code{\link{eventMinima}}
}
\keyword{baseflow}
\keyword{events}
