% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesize.R
\name{lrt}
\alias{lrt}
\title{Likelihood Ratio Test}
\usage{
lrt(null_loglik, alt_loglik, dof)
}
\arguments{
\item{null_loglik}{Numeric. The maximized log-likelihood under the null
(simpler) model.}

\item{alt_loglik}{Numeric. The maximized log-likelihood under the
alternative (more complex) model.}

\item{dof}{Positive integer. Degrees of freedom, typically the difference
in the number of free parameters between models.}
}
\value{
A \code{hypothesis_test} object of subclass \code{likelihood_ratio_test}
containing:
\describe{
\item{stat}{The LRT statistic \eqn{\Lambda = -2(\ell_0 - \ell_1)}}
\item{p.value}{P-value from chi-squared distribution with \code{dof} degrees
of freedom}
\item{dof}{The degrees of freedom}
\item{null_loglik}{The input null model log-likelihood}
\item{alt_loglik}{The input alternative model log-likelihood}
}
}
\description{
Computes the likelihood ratio test (LRT) statistic and p-value for
comparing nested models.
}
\details{
The likelihood ratio test is a fundamental method for comparing nested
statistical models. Given a null model \eqn{M_0} (simpler, fewer parameters)
nested within an alternative model \eqn{M_1} (more complex), the LRT tests
whether the additional complexity of \eqn{M_1} is justified by the data.

The test statistic is:

\deqn{\Lambda = -2 \left( \ell_0 - \ell_1 \right) = -2 \log \frac{L_0}{L_1}}

where \eqn{\ell_0} and \eqn{\ell_1} are the maximized log-likelihoods under
the null and alternative models, respectively.

Under \eqn{H_0} and regularity conditions, \eqn{\Lambda} is asymptotically
chi-squared distributed with degrees of freedom equal to the difference in
the number of free parameters between models.
}
\section{Assumptions}{

\enumerate{
\item The null model must be nested within the alternative model
(i.e., obtainable by constraining parameters of the alternative).
\item Both likelihoods must be computed from the same dataset.
\item Standard regularity conditions for asymptotic chi-squared
distribution must hold (true parameter not on boundary, etc.).
}
}

\section{Relationship to Other Tests}{

The LRT is one of the "holy trinity" of likelihood-based tests, alongside
the Wald test (\code{\link[=wald_test]{wald_test()}}) and the score (Lagrange multiplier) test.
All three are asymptotically equivalent under \eqn{H_0}, but the LRT is
often preferred because it is invariant to reparameterization.
}

\examples{
# Comparing nested regression models
# Null model: y ~ x1 (log-likelihood = -150)
# Alt model:  y ~ x1 + x2 + x3 (log-likelihood = -140)
# Difference: 3 additional parameters

test <- lrt(null_loglik = -150, alt_loglik = -140, dof = 3)
test

# Is the more complex model significantly better?
is_significant_at(test, 0.05)

# Extract the test statistic (should be 20)
test_stat(test)

# Access stored inputs for inspection
test$null_loglik
test$alt_loglik

}
\seealso{
\code{\link[=wald_test]{wald_test()}} for testing individual parameters
}
