% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{missing_to_cat}
\alias{missing_to_cat}
\title{Convert missing values to categorical variables}
\usage{
missing_to_cat(data, vars, names = NULL)
}
\arguments{
\item{data}{a dataframe with the columns to convert
its missing values into categorical}

\item{vars}{a character vector of the variables in \code{data}
for conversion of missing values}

\item{names}{a character vector of names for the new variables}
}
\value{
original dataframe containing new columns of the converted variables
       for the missing values with tidyverse code attached
}
\description{
Turn \code{<NA>} in categorical variables into \code{"(Missing)"};
numeric variables will be converted to categorical variables where numeric
values as \code{"(Observed)"} and \code{NA} as \code{"(Missing)"}.
}
\examples{
missing <- missing_to_cat(iris, vars = c("Species", "Sepal.Length"))
cat(code(missing))
head(missing)

}
\seealso{
\code{\link{code}}
}
\author{
Zhaoming Su
}
