% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_create_class2use.R
\name{ifcb_create_class2use}
\alias{ifcb_create_class2use}
\title{Create a class2use \code{.mat} File}
\usage{
ifcb_create_class2use(classes, filename, do_compression = TRUE)
}
\arguments{
\item{classes}{A character vector of class names to be saved in the \code{.mat} file.}

\item{filename}{A string specifying the output file path (with \code{.mat} extension).}

\item{do_compression}{A logical value indicating whether to compress the \code{.mat} file. Defaults to \code{TRUE}.}
}
\value{
No return value. This function is called for its side effect of creating a \code{.mat} file.
}
\description{
This function creates a \code{.mat} file containing a character vector of class names.
A class2use file can be used for manual annotation using the code in the \code{ifcb-analysis}
repository (Sosik and Olson 2007).
}
\details{
Python must be installed to use this function. The required python packages can be installed in a virtual environment using \code{ifcb_py_install()}.
}
\examples{
\dontrun{
# Initialize a python session if not already set up
ifcb_py_install()

# Example usage:
classes <- c("unclassified", "Dinobryon_spp", "Helicostomella_spp")

ifcb_create_class2use(classes, "class2use_output.mat", do_compression = TRUE)
}
}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
\seealso{
\code{\link{ifcb_py_install}} \code{\link{ifcb_adjust_classes}} \url{https://github.com/hsosik/ifcb-analysis}
}
