% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_indiedown_fonts.R
\name{use_indiedown_gfonts}
\alias{use_indiedown_gfonts}
\title{Download and Use Google Fonts}
\usage{
use_indiedown_gfonts(
  path = ".",
  id = "roboto",
  variants = c("regular", "300italic", "700", "700italic")
)
}
\arguments{
\item{path}{Package path}

\item{id}{Id of the font, correspond to column \code{id} from \code{\link[gfonts]{get_all_fonts}}.}

\item{variants}{Variant(s) to download, default is to includes all available ones.}
}
\value{
This function is called for its side effects and returns \code{NULL}, invisibly.
}
\description{
Download and use Google fonts, using the \emph{gfonts} package.
}
\examples{
\donttest{
path <- file.path(tempdir(), "mydown")
create_indiedown_package(path, overwrite = TRUE)
# Use Lora, instead of default Roboto
use_indiedown_gfonts(
  path = path,
  id = "lora",
  variants = c("regular", "italic", "700", "700italic")
)
}
}
