% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper.fm_mesh_2d}
\alias{bru_mapper.fm_mesh_2d}
\alias{ibm_n.bm_fm_mesh_2d}
\alias{ibm_values.bm_fm_mesh_2d}
\alias{ibm_jacobian.bm_fm_mesh_2d}
\alias{ibm_n.bm_inla_mesh_2d}
\alias{ibm_values.bm_inla_mesh_2d}
\alias{ibm_jacobian.bm_inla_mesh_2d}
\title{Mapper for \code{fm_mesh_2d}}
\usage{
\method{bru_mapper}{fm_mesh_2d}(mesh, ...)

\method{ibm_n}{bm_fm_mesh_2d}(mapper, ...)

\method{ibm_values}{bm_fm_mesh_2d}(mapper, ...)

\method{ibm_jacobian}{bm_fm_mesh_2d}(mapper, input, ...)

\method{ibm_n}{bm_inla_mesh_2d}(mapper, ...)

\method{ibm_values}{bm_inla_mesh_2d}(mapper, ...)

\method{ibm_jacobian}{bm_inla_mesh_2d}(mapper, input, ...)
}
\arguments{
\item{mesh}{An \code{fm_mesh_2d} object to use as a mapper}

\item{...}{Arguments passed on to other methods}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{input}{Data input for the mapper.}
}
\value{
A \code{bm_fmesher} object. Note: Prior to version \verb{2.12.0.9021},
this was a \code{bru_mapper_fm_mesh_2d} object. Also see the note for
\code{\link[=bru_mapper.fm_mesh_1d]{bru_mapper.fm_mesh_1d()}}.
}
\description{
Creates a mapper for 2D \code{fm_mesh_2d} objects. Equivalent
to calling \code{\link[=bm_fmesher]{bm_fmesher()}}.
}
\examples{
m <- bru_mapper(fmesher::fmexample$mesh)
ibm_n(m)
ibm_eval(m, as.matrix(expand.grid(-2:2, -2:2)), seq_len(ibm_n(m)))

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bm_aggregate}()},
\code{\link{bm_collect}()},
\code{\link{bm_const}()},
\code{\link{bm_factor}()},
\code{\link{bm_fmesher}()},
\code{\link{bm_harmonics}()},
\code{\link{bm_index}()},
\code{\link{bm_linear}()},
\code{\link{bm_logsumexp}()},
\code{\link{bm_marginal}()},
\code{\link{bm_matrix}()},
\code{\link{bm_mesh_B}()},
\code{\link{bm_multi}()},
\code{\link{bm_pipe}()},
\code{\link{bm_repeat}()},
\code{\link{bm_scale}()},
\code{\link{bm_shift}()},
\code{\link{bm_sum}()},
\code{\link{bm_taylor}()},
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper_generics}}
}
\concept{mappers}
