% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R, R/model.R
\name{bm_list}
\alias{bm_list}
\alias{as_bm_list}
\alias{as_bm_list.list}
\alias{as_bm_list.bm_list}
\alias{as_bm_list.bru_comp_list}
\alias{c.bru_mapper}
\alias{c.bm_list}
\alias{[.bm_list}
\alias{ibm_linear.bm_list}
\alias{ibm_simplify.bm_list}
\title{Methods for mapper lists}
\usage{
as_bm_list(x)

\method{as_bm_list}{list}(x)

\method{as_bm_list}{bm_list}(x)

\method{as_bm_list}{bru_comp_list}(x)

\method{c}{bru_mapper}(...)

\method{c}{bm_list}(...)

\method{[}{bm_list}(x, i)

\method{ibm_linear}{bm_list}(mapper, input, state = NULL, ...)

\method{ibm_simplify}{bm_list}(mapper, input = NULL, state = NULL, ...)
}
\arguments{
\item{x}{\code{bm_list} object from which to extract element(s)}

\item{\dots}{Objects to be combined.}

\item{i}{indices specifying elements to extract}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{input}{Data input for the mapper.}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}
}
\value{
A \code{bm_list} object
}
\description{
\code{bru_mapper} lists can be combined into \code{bm_list} lists.
}
\section{Methods (by generic)}{
\itemize{
\item \code{c(bm_list)}: The \code{...} arguments should be \code{bm_list}
objects.

\item \code{[}: Extract sub-list

}}
\section{Functions}{
\itemize{
\item \code{c(bru_mapper)}: The \code{...} arguments should be \code{bru_mapper}
objects.

}}
\examples{
m <- c(A = bm_const(), B = bm_scale())
str(m)
str(m[2])
}
