% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgl.R
\name{globe}
\alias{globe}
\title{Visualize a globe using RGL}
\usage{
globe(
  R = 1,
  R.grid = 1.05,
  specular = "black",
  axes = FALSE,
  box = FALSE,
  xlab = "",
  ylab = "",
  zlab = ""
)
}
\arguments{
\item{R}{Radius of the globe}

\item{R.grid}{Radius of the annotation sphere.}

\item{specular}{Light color of specular effect.}

\item{axes}{If TRUE, plot x, y and z axes.}

\item{box}{If TRUE, plot a box around the globe.}

\item{xlab, ylab, zlab}{Axes labels}
}
\value{
No value, used for plotting side effect.
}
\description{
Creates a textured sphere and lon/lat coordinate annotations.
This function requires the \code{rgl} and \code{sphereplot} packages.
}
\examples{
\donttest{
if (interactive() &&
    require("rgl", quietly = TRUE) &&
    require("sphereplot", quietly = TRUE) &&
    bru_safe_sp() &&
    require("sp")) {
  # Show the globe
  globe()

  # Load pantropoical dolphin data
  mexdolphin <- inlabru::mexdolphin_sp()

  # Add mesh, ship transects and dolphin sightings stored
  # as fm_mesh_2d, SpatialLines and SpatialPoints objects, respectively

  glplot(mexdolphin$mesh, alpha = 0.2)
  glplot(mexdolphin$samplers, lwd = 5)
  glplot(mexdolphin$points, size = 10)
}
}
}
\seealso{
Other inlabru RGL tools: 
\code{\link{glplot}()}
}
\concept{inlabru RGL tools}
