% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_icm.R
\name{fit_icm}
\alias{fit_icm}
\title{Fit the Interval Consensus Model}
\usage{
fit_icm(
  df_simplex,
  id_person,
  id_item,
  item_labels = NULL,
  link = "ilr",
  padding = 0,
  iter_sampling = 500,
  iter_warmup = 500,
  n_chains = 4,
  n_cores = 1,
  adapt_delta = 0.9,
  ...
)
}
\arguments{
\item{df_simplex}{A dataframe containing the simplex data.}

\item{id_person}{A vector of person indices.}

\item{id_item}{A vector of item indices.}

\item{item_labels}{A vector of item labels. Can be long format matching id_item or
a vector of unique labels in ascending order. Default is NULL.}

\item{link}{A character string specifying the link function. Options are "ilr" (Isometric Log-Ratio) or "slr" (Sum Log-Ratio).
See also \code{\link[=ilr]{ilr()}} and \code{\link[=slr]{slr()}} for details. Default is "ilr".}

\item{padding}{Padding constant that was used to remove zero-components from the simplex. Default is 0.
The model will reverse the padding when transforming results back to the original interval response scale. See also \code{\link[=remove_zeros]{remove_zeros()}} for details.}

\item{iter_sampling}{An integer specifying the number of sampling iterations used by \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}} Default is 500.}

\item{iter_warmup}{An integer specifying the number of warmup iterations used by \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}} Default is 500.}

\item{n_chains}{An integer specifying the number of Markov chains used by \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}} Default is 4.}

\item{n_cores}{An integer specifying the number of cores to use used by \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}} Default is 1.}

\item{adapt_delta}{A numeric value specifying the target acceptance rate used by \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}} Default is 0.9.}

\item{...}{Additional arguments passed to the \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}} function.}
}
\value{
A fitted Stan model object of class \code{icm_stanfit} containing the following components:
\describe{
\item{stan_model}{The compiled Stan model object.}
\item{stan_fit}{The fitted Stan model with posterior samples for the model parameters (see below).}
\item{stan_data}{The data list passed to Stan.}
\item{item_labels}{A vector of item labels.}
}

The \code{stan_fit} component contains posterior samples for these ICM parameters:
\describe{
\item{Person Parameters:}{
\itemize{
\item \code{E_loc} - Person proficiency for location
\item \code{E_wid} - Person proficiency for width
\item \code{a_loc} - Person scaling bias for location
\item \code{b_loc} - Person shifting bias for location
\item \code{b_wid} - Person shifting bias for width
\item \code{rho_E} - Correlation between person proficiencies for location and width
}
}
\item{Item Parameters:}{
\itemize{
\item \code{Tr_loc} - Item consensus location in the logit-transformed space
\item \code{Tr_wid} - Item consensus width in the logit-transformed space
\item \code{Tr_loc_splx} - Item consensus location in the simplex space
\item \code{Tr_wid_splx} - Item consensus width in the simplex space
\item \code{Tr_L} - Item consensus lower bound
\item \code{Tr_U} - Item consensus upper bound
\item \code{Tr_splx} - Item consensus simplex representation
\item \code{lambda_loc} - Item discernibility for location
\item \code{lambda_wid} - Item discernibility for width
\item \code{omega} - Item residual correlations between location and width
\item \code{rho_lambda} - Correlation between item discernibilities for location and width
}
}
\item{Hyperparameters:}{
\itemize{
\item \code{mu_E} - Means for person proficiencies
\item \code{sigma_I} - Standard deviations for person parameters
\item \code{sigma_lambda} - Standard deviations for item discernibilities
}
}
\item{Posterior Predictive Checks:}{
\itemize{
\item \code{Y_ppc_loc} - Predicted responses for location in the logit-transformed space
\item \code{Y_ppc_wid} - Predicted responses for width in the logit-transformed space
\item \code{Y_ppc_splx} - Predicted responses in simplex space
\item \code{Y_ppc_loc_splx} - Predicted location responses in the simplex space (mean of lower and upper bound)
\item \code{Y_ppc_wid_splx} - Predicted width responses in the simplex space
}
}
}
}
\description{
This function fits the Interval Consensus Model (ICM, Kloft et al., 2024) using Stan.
}
\examples{
\donttest{
# Create minimal example data
df_simplex <- data.frame(
  x1 = c(0.3, 0.4, 0.2, 0.5),
  x2 = c(0.3, 0.2, 0.4, 0.2),
  x3 = c(0.4, 0.4, 0.4, 0.3)
)
id_person <- c(1, 1, 2, 2)
id_item <- c(1, 2, 1, 2)

# Fit ICM model (reduce iterations for faster example)
fit <- fit_icm(df_simplex, id_person, id_item, n_chains = 1,
               iter_sampling = 100, iter_warmup = 100,
               refresh = 0)

# Print summary of the fit
summary(fit)
}
}
\references{
Kloft, M., Siepe, B. S., & Heck, D. W. (2024).
The Interval Truth Model: A Consensus Model for Continuous Bounded Interval Responses.
\doi{doi:10.31234/osf.io/dzvw2}
}
