% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{caco2_L0}
\alias{caco2_L0}
\title{Caco-2 Level-0 Example Data set}
\format{
A level-0 data.frame with 48 rows and 17 variables: \describe{
\item{\code{Compound}}{Compound name}
\item{\code{DTXSID}}{DSSTox Substance Identifier (CompTox Chemicals Dashboard)}
\item{\code{Lab.Compound.ID}}{Compound ID used in the laboratory}
\item{\code{Date}}{Date MS/MS assay data acquired from instrument}
\item{\code{Sample}}{Sample Name}
\item{\code{Type}}{Type of Caco-2 sample}
\item{\code{Compound.Conc}}{Expected (or nominal) concentration of analyte (for calibration curve)}
\item{\code{Peak.Area}}{Peak area of analyte (target compound)}
\item{\code{ISTD.Peak.Area}}{Peak area of internal standard (pixels)}
\item{\code{ISTD.Name}}{Name of compound used as internal standard (ISTD)}
\item{\code{Analysis.Params}}{General description of chemical analysis method}
\item{\code{Level0.File}}{Name of data file from laboratory that was used to compile level-0 data.frame}
\item{\code{Level0.Sheet}}{Name of "sheet" (for Excel workbooks) from which the laboratory data were read}
\item{\code{Direction}}{Direction of the Caco-2 permeability experiment}
\item{\code{Vol.Donor}}{The media volume (in cm^3) of the donor portion of the Caco-2 experimental well}
\item{\code{Vol.Receiver}}{The media volume (in cm^3) of the receiver portion of the Caco-2 experimental well}
\item{\code{Dilution.Factor}}{Number of times the sample was diluted}
}
}
\usage{
caco2_L0
}
\description{
A subset of tandem mass spectrometry (MS/MS) measurements of Caco-2 assay-specific
data \insertCite{honda2025impact}{invitroTKstats}. This subset contains samples for 3 test analytes/compounds.
}
\references{
\insertRef{honda2025impact}{invitroTKstats}
}
\keyword{datasets}
