% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iprior_cv.R
\name{iprior_cv}
\alias{iprior_cv}
\alias{iprior_cv.default}
\alias{iprior_cv.formula}
\title{Perform a cross-validation experiment with the iprior function}
\usage{
\method{iprior_cv}{default}(
  y,
  ...,
  folds = 2,
  par.cv = TRUE,
  kernel = "linear",
  method = "direct",
  control = list(),
  interactions = NULL,
  est.lambda = TRUE,
  est.hurst = FALSE,
  est.lengthscale = FALSE,
  est.offset = FALSE,
  est.psi = TRUE,
  fixed.hyp = NULL,
  lambda = 1,
  psi = 1,
  nystrom = FALSE,
  nys.seed = NULL
)

\method{iprior_cv}{formula}(
  formula,
  data,
  folds = 2,
  one.lam = FALSE,
  par.cv = TRUE,
  kernel = "linear",
  method = "direct",
  control = list(),
  est.lambda = TRUE,
  est.hurst = FALSE,
  est.lengthscale = FALSE,
  est.offset = FALSE,
  est.psi = TRUE,
  fixed.hyp = NULL,
  lambda = 1,
  psi = 1,
  nystrom = FALSE,
  nys.seed = NULL,
  ...
)
}
\arguments{
\item{y}{Vector of response variables}

\item{...}{Only used when fitting using non-formula, enter the variables
(vectors or matrices) separated by commas.}

\item{folds}{The number of cross-validation folds. Set equal to sample size
or \code{Inf} to perform leave-one-out cross-validation.}

\item{par.cv}{Logical. Multithreading to fit the models? Defaults to
\code{TRUE}.}

\item{kernel}{Character vector indicating the type of kernel for the
variables. Available choices are: \itemize{ \item{\code{"linear"} -
(default) for the linear kernel} \item{\code{"canonical"} - alternative
name for \code{"linear"}} \item{\code{"fbm"}, \code{"fbm,0.5"} - for the
fBm kernel with Hurst coefficient 0.5 (default)} \item{\code{"se"},
\code{"se,1"} - for the SE kernel with lengthscale 1 (default)}
\item{\code{"poly"}, \code{"poly2"}, \code{"poly2,0"} - for the polynomial
kernel of degree 2 with offset 0 (default)} \item{\code{"pearson" - for the
Pearson kernel}}} The \code{kernel} argument can also be a vector of length
equal to the number of variables, therefore it is possible to specify
different kernels for each variables. Note that factor type variables are
assigned the Pearson kernel by default, and that non-factor types can be
forced to use the Pearson kernel (not recommended).}

\item{method}{The estimation method. One of: \itemize{ \item{\code{"direct"}
- for the direct minimisation of the marginal deviance using
\code{optim()}'s L-BFGS method} \item{\code{"em"} - for the EM algorithm}
\item{\code{"mixed"} - combination of the direct and EM methods}
\item{\code{"fixed"} - for just obtaining the posterior regression function
with fixed hyperparameters (default method when setting \code{fixed.hyp =
TRUE})} \item{\code{"canonical"} - an efficient estimation method which
takes advantage of the structure of the linear kernel} }}

\item{control}{(Optional) A list of control options for the estimation
procedure: \describe{ \item{\code{maxit}}{The maximum number of iterations
for the quasi-Newton optimisation or the EM algorithm. Defaults to
\code{100}.} \item{\code{em.maxit}}{For \code{method = "mixed"}, the number
of EM steps before switching to direct optimisation. Defaults to \code{5}.}
\item{\code{stop.crit}}{The stopping criterion for the EM and L-BFGS
algorithm, which is the difference in successive log-likelihood values.
Defaults to \code{1e-8}.} \item{\code{theta0}}{The initial values for the
hyperparameters. Defaults to random starting values.}
\item{\code{report}}{The interval of reporting for the \code{optim()}
function.} \item{\code{restarts}}{The number of random restarts to perform.
Defaults to \code{0}. It's also possible to set it to \code{TRUE}, in which
case the number of random restarts is set to the total number of available
cores.} \item{\code{no.cores}}{The number of cores in which to do random
restarts. Defaults to the total number of available cores.}
\item{\code{omega}}{The overrelaxation parameter for the EM algorithm - a
value between 0 and 1.}}}

\item{interactions}{Character vector to specify the interaction terms. When
using formulas, this is specified automatically, so is not required. Syntax
is \code{"a:b"} to indicate variable \code{a} interacts with variable
\code{b}.}

\item{est.lambda}{Logical. Estimate the scale parameters? Defaults to
\code{TRUE}.}

\item{est.hurst}{Logical. Estimate the Hurst coefficients for fBm kernels?
Defaults to \code{FALSE}.}

\item{est.lengthscale}{Logical. Estimate the lengthscales for SE kernels?
Defaults to \code{FALSE}.}

\item{est.offset}{Logical. Estimate the offsets for polynomial kernels?
Defaults to \code{FALSE}.}

\item{est.psi}{Logical. Estimate the error precision? Defaults to
\code{TRUE}.}

\item{fixed.hyp}{Logical. If \code{TRUE}, then no hyperparameters are
estimated, i.e. all of the above \code{est.x} are set to \code{FALSE}, and
vice versa. If \code{NULL} (default) then all of the \code{est.x} defaults
are respected.}

\item{lambda}{Initial/Default scale parameters. Relevant especially if
\code{est.lambda = FALSE}.}

\item{psi}{Initial/Default value for error precision. Relevant especially if
\code{est.psi = FALSE}.}

\item{nystrom}{Either logical or an integer indicating the number of Nystrom
samples to take. Defaults to \code{FALSE}. If \code{TRUE}, then
approximately 10\% of the sample size is used for the Nystrom
approximation.}

\item{nys.seed}{The random seed for the Nystrom sampling. Defaults to
\code{NULL}, which means the random seed is not fixed.}

\item{formula}{The formula to fit when using formula interface.}

\item{data}{Data frame containing variables when using formula interface.}

\item{one.lam}{Logical. When using formula input, this is a convenient way of
letting the function know to treat all variables as a single variable (i.e.
shared scale parameter). Defaults to \code{FALSE}.}
}
\value{
An \code{iprior_xv} object containing a data frame of the
  cross-validated values such as the log-likelihood, training MSE and test
  MSE.
}
\description{
A convenience function to perform a k-fold cross-validation experiment and
obtain mean squared error of prediction. Most of the arguments are similar to
\code{iprior()} and \code{kernL()}.
}
\details{
Uses a multicore loop to fit the folds by default, set \code{par.cv = FALSE}
to not use multithreading.
}
\examples{
\dontrun{

# 5-fold CV experiment
(mod.cv <- iprior_cv(y ~ X, gen_smooth(100), kernel = "se", folds = 5))

# LOOCV experiment
(mod.cv <- iprior_cv(y ~ X, gen_smooth(100), kernel = "se", folds = Inf))

# Can also get root MSE
print(mod.cv, "RMSE")
}

}
