% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_ellipse.R
\docType{methods}
\name{ternary_ellipse}
\alias{ternary_ellipse}
\alias{ternary_ellipse-method}
\alias{ternary_confidence}
\alias{ternary_tolerance}
\alias{ternary_ellipse,numeric,numeric,numeric-method}
\alias{ternary_ellipse,ANY,missing,missing-method}
\alias{ternary_confidence,numeric,numeric,numeric-method}
\alias{ternary_confidence,ANY,missing,missing-method}
\alias{ternary_tolerance,numeric,numeric,numeric-method}
\alias{ternary_tolerance,ANY,missing,missing-method}
\title{Add an Ellipse to a Ternary Plot}
\usage{
ternary_ellipse(x, y, z, ...)

ternary_confidence(x, y, z, ...)

ternary_tolerance(x, y, z, ...)

\S4method{ternary_ellipse}{numeric,numeric,numeric}(x, y, z, radius = 1, ...)

\S4method{ternary_ellipse}{ANY,missing,missing}(x, radius = 1, ...)

\S4method{ternary_confidence}{numeric,numeric,numeric}(x, y, z, level = 0.95, ...)

\S4method{ternary_confidence}{ANY,missing,missing}(x, level = 0.95, ...)

\S4method{ternary_tolerance}{numeric,numeric,numeric}(x, y, z, level = 0.95, ...)

\S4method{ternary_tolerance}{ANY,missing,missing}(x, level = 0.95, ...)
}
\arguments{
\item{x, y, z}{A \code{\link{numeric}} vector giving the x, y and z ternary coordinates
of a set of points. If \code{y} and \code{z} are missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xyz.coords]{grDevices::xyz.coords()}}).}

\item{...}{Further arguments to be passed to \code{\link[graphics:polygon]{graphics::polygon()}}.}

\item{radius}{A \code{\link{numeric}} vector specifying the scaling of the
half-diameters.}

\item{level}{A \code{\link{numeric}} vector specifying the confidence/tolerance level.}
}
\value{
\code{ternary_ellipse()} is called it for its side-effects.
}
\description{
Computes and draws a confidence/tolerance ellipse.
}
\details{
Ellipse coordinates are computed after an isometric log ratio transformation
of the original data.
}
\examples{
## Ellipses
## Data from Aitchison 1986
ternary_plot(lava, panel.first = ternary_grid(5, 10))
ternary_tolerance(lava, level = 0.95, border = "blue", lty = 2)
ternary_confidence(lava, level = 0.95, border = "red", lty = 3)
}
\seealso{
\code{\link[graphics:polygon]{graphics::polygon()}}

Other statistics: 
\code{\link{ternary_contour}()},
\code{\link{ternary_density}()},
\code{\link{ternary_hull}()},
\code{\link{ternary_mean}()},
\code{\link{ternary_pca}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
