% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{codepoint}
\alias{codepoint}
\alias{codepointToKanji}
\alias{kanjiToCodepoint}
\title{Convert between Unicode codepoint and kanji}
\usage{
codepointToKanji(cp, concat = FALSE)

kanjiToCodepoint(kan, character = FALSE)
}
\arguments{
\item{cp}{a vector of character strings or objects of class \code{hexmode}, representing
hexadecimal numbers.}

\item{concat}{logical. Shall the returned characters be concatenated?}

\item{kan}{a vector of kanjis (strings of length 1) or a single string of length >= 1
of kanjis.}

\item{character}{logical. Shall the returned codepoints be of class "character" or hexmode.}
}
\value{
For \code{codepointToKanji} a character vector of kanji. For \code{kanjiToCodepoint} a vector
of hexadecimal numbers (class \code{hexmode}).
}
\description{
Given codepoints \code{cp}, the function \code{codepointToKanji} transforms
to UTF-8, which will typically show as the actual character the codepoints stands for.
Vice versa, given (UTF-8 encoded) kanjis \code{kan}, the function \code{kanjiToCodepoint} transforms
to unicode codepoints.
}
\examples{
codepointToKanji(c("51b7", "6696", "71b1"))
kanjiToCodepoint("\u51b7\u6696\u71b1")

}
