% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{getTidyData}
\alias{getTidyData}
\title{Get tidy-style data from \code{TapestriExperiment} objects}
\usage{
getTidyData(
  TapestriExperiment,
  alt.exp = NULL,
  assay = NULL,
  feature.id.as.factor = TRUE
)
}
\arguments{
\item{TapestriExperiment}{\code{TapestriExperiment} object.}

\item{alt.exp}{Character, \code{altExp} slot to use. \code{NULL} (default) uses top-level/main experiment.}

\item{assay}{Character, \code{assay} slot to use. \code{NULL} (default) uses first-indexed assay (often "counts").}

\item{feature.id.as.factor}{Logical, if \code{TRUE} (default), the feature.id column is returned as a factor.}
}
\value{
A \code{tibble} of tidy data with corresponding metadata from \code{colData} and \code{rowData}.
}
\description{
\code{getTidyData()} pulls data from the indicated \code{assay} and/or \code{altExp} slot(s), and rearranges it into tidy format.
\code{colData} (cell metadata) from the top-level/main experiment is included.
\code{rowData} (probe metadata) from the indicated \code{assay} and/or \code{altExp} slot(s) is included.
Attempts are made to sort by "chr" and "start.pos" columns if they are present to simplify plotting and other downstream operations.
}
\examples{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
tidy.data <- getTidyData(tap.object, alt.exp = "alleleFrequency")
}
\concept{copy number}
