% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk.R
\name{risk_pred_core}
\alias{risk_pred_core}
\title{KFRE risk prediction for a single person}
\usage{
risk_pred_core(
  age,
  sex,
  eGFR,
  uACR,
  is_north_american,
  dm = NULL,
  htn = NULL,
  albumin = NULL,
  phosphorous = NULL,
  bicarbonate = NULL,
  calcium = NULL,
  years = 2
)
}
\arguments{
\item{age}{Numeric age in years.}

\item{sex}{Integer sex indicator, 1 for male, 0 for female.}

\item{eGFR}{Estimated glomerular filtration rate, mL/min/1.73 \eqn{\text{m}^{2}}.}

\item{uACR}{Urine albumin to creatinine ratio, mg/g.}

\item{is_north_american}{Logical, patient from a North American cohort.}

\item{dm}{Optional integer diabetes indicator, 1 yes, 0 no.}

\item{htn}{Optional integer hypertension indicator, 1 yes, 0 no.}

\item{albumin}{Optional serum albumin, g/dL, required for 8 variable model.}

\item{phosphorous}{Optional serum phosphorus, mg/dL, 8 variable model.}

\item{bicarbonate}{Optional serum bicarbonate, mmol/L, 8 variable model.}

\item{calcium}{Optional serum calcium, mg/dL, 8 variable model.}

\item{years}{Integer, prediction horizon, 2 or 5.}
}
\value{
Numeric probability between 0 and 1.
}
\description{
Computes the Kidney Failure Risk Equation probability at 2 or 5 years.
}
\examples{
risk_pred_core(60, 1, 45, 120, TRUE, dm = 1, htn = 1, years = 2)
}
\references{
Tangri, N., Stevens, L. A., Griffith, J., Tighiouart, H., Djurdjev, O., Naimark, D., Levin, A., &
Levey, A. S. (2011). A predictive model for progression of chronic kidney disease to kidney failure.
\emph{JAMA}, 305(15), 1553–1559. \doi{10.1001/jama.2011.451}

Tangri, N., Grams, M. E., Levey, A. S., et al. (2016). Multinational assessment of the accuracy of the
Kidney Failure Risk Equation in people with chronic kidney disease. \emph{JAMA}, 315(2), 164–174.
\doi{10.1001/jama.2015.18202}
}
