% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kissmigAccess.R
\name{kissmigAccess}
\alias{kissmigAccess}
\title{Get accessiblity map from kissmig output}
\usage{
kissmigAccess(grd, rel = FALSE)
}
\arguments{
\item{grd}{SpatRaster with one layer as first occurrence generated by kissmig.}

\item{rel}{bool. If \code{TRUE}, kissmigAccess returns relative values with maximum \code{1}, otherwise absolute integer values.
Defaults to \code{FALSE}.}
}
\description{
\command{kissmigAccess} calculates an accessibility map from a \code{\link{kissmig}} output of first occurrence (\code{type}=\code{"FOC"}).
These maps allows the integration of limited migration in species distribution models and macroecological analyses.
}
\details{
\code{\link{kissmig}} maps of first occurrences show values of the first iteration step a raster cell was colonized. Early
colonized cells have low values, late colonized cells high values. These values are the opposite of accessibility,
which is high for early colonized, and low for late colonized cells. \command{kissmigAccess} simply calculates for each
cell the accessibility as the difference between the cell value and \command{max(grd)+1}. Cells which have never been
colonized remain unchanged (value \code{0}).
}
\seealso{
\code{\link{kissmig}}
}
