% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heightgraph.R
\name{addHeightgraph}
\alias{addHeightgraph}
\title{Add a Heightgraph layer}
\usage{
addHeightgraph(
  map,
  data = NULL,
  columns = NULL,
  layerId = NULL,
  group = NULL,
  color = "#03F",
  weight = 5,
  opacity = 0.5,
  dashArray = NULL,
  smoothFactor = 1,
  noClip = FALSE,
  pathOpts = leaflet::pathOptions(),
  options = heightgraphOptions()
)
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}()}}

\item{data}{A Simple Feature LINESTRING with Z dimension.}

\item{columns}{A character vector of the columns you want to include in the
heightgraph control}

\item{layerId}{the layer id}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{color}{stroke color}

\item{weight}{stroke width in pixels}

\item{opacity}{stroke opacity (or layer opacity for tile layers)}

\item{dashArray}{a string that defines the stroke
\href{https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-dasharray}{dash
pattern}}

\item{smoothFactor}{how much to simplify the polyline on each zoom level
(more means better performance and less accurate representation)}

\item{noClip}{whether to disable polyline clipping}

\item{pathOpts}{List of further options for the path. See
\code{\link[leaflet]{pathOptions}}}

\item{options}{List of further plugin options. See
\code{\link{heightgraphOptions}}}
}
\value{
the new \code{map} object
}
\description{
Visualize height information and road attributes of linestring segments.
The linestrings must be a Simple Feature LINESTRING Z and are transformed to
GeoJSON. The function therefore inherits arguments from
\code{\link[leaflet]{addGeoJSON}}.
}
\note{
When used in Shiny, 3 events update a certain Shiny Input:
\enumerate{
  \item A click updates \code{input$MAPID_heightgraph_click}
  \item A mouseover updates \code{input$MAPID_heightgraph_mouseover}
  \item A mouseout updates \code{input$MAPID_heightgraph_mouseout}
}
If you want to explicitly remove the Heightgraph control, please use
\code{\link[leaflet]{removeControl}} with the \code{layerId = "hg_control"}.
}
\examples{
library(leaflet)
library(leaflet.extras2)
library(sf)

data <- st_cast(st_as_sf(leaflet::atlStorms2005[4, ]), "LINESTRING")
data <- st_transform(data, 4326)
data <- data.frame(st_coordinates(data))
data$elev <- round(runif(nrow(data), 10, 500), 2)
data$L1 <- NULL
L1 <- round(seq.int(1, 4, length.out = nrow(data)))
data <- st_as_sf(st_sfc(lapply(split(data, L1), function(x) {
  st_linestring(as.matrix(x))
})))
data$steepness <- 1:nrow(data)
data$suitability <- nrow(data):1
data$popup <- apply(data, 1, function(x) {
  sprintf("Steepness: \%s<br>Suitability: \%s", x$steepness, x$suitability)
})

leaflet() \%>\%
  addTiles(group = "base") \%>\%
  addHeightgraph(
    color = "red", columns = c("steepness", "suitability"),
    opacity = 1, data = data, group = "heightgraph",
    options = heightgraphOptions(width = 400)
  )
}
\references{
\url{https://github.com/GIScience/Leaflet.Heightgraph}
}
\seealso{
Other Heightgraph Functions: 
\code{\link{heightgraphOptions}()}
}
\concept{Heightgraph Functions}
