% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{compile_report}
\alias{compile_report}
\title{Enhanced report compilation with numeric severity scores}
\usage{
compile_report(
  results,
  audit_data,
  config,
  show_config = FALSE,
  top_n = 10,
  report = "default"
)
}
\arguments{
\item{results}{A list containing detection results.}

\item{audit_data}{The audit data used for the report.}

\item{config}{Configuration settings, including whether to use numeric severity scores.}

\item{show_config}{Logical, whether to display the configuration used for report generation. Defaults to FALSE.}

\item{top_n}{Numeric, the number of top results to display in the report. Defaults to 10.}

\item{report}{A string indicating the type of report to generate. Defaults to "default".}
}
\value{
A \code{leakr_report} object containing the summary, evidence, and metadata for the report.
}
\description{
This function compiles a report with enhanced sorting, severity scoring,
and detailed metadata, including configuration information.
}
