% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxNMI.R
\name{maxNMI}
\alias{maxNMI}
\title{Maximal Normalized Mutual Information (MaxNMI)}
\usage{
maxNMI(x, y, includeNA = T, maxNbBins = 100, showProgress = F)
}
\arguments{
\item{x}{a vector of numeric or factor.}

\item{y}{a vector of numeric or factor.}

\item{includeNA}{a boolean. TRUE to include NA value as a factor level.}

\item{maxNbBins}{an integer corresponding to the number of bins limitation (for computation time limitation), maxNbBins=100 by default.}

\item{showProgress}{a boolean to decide whether to show the progress bar.}
}
\value{
a double between 0 and 1 corresponding to the MaxNMI.
}
\description{
Computes the MaxNMI between the two variables whatever their types, by discretizing using Best Equal-Frequency-based discretization (BeEF) if necessary.
}
\examples{
# calculate a correlation dataframe
data(iris)
maxNMI(iris$Sepal.Length,iris$Species)
maxNMI(iris$Sepal.Length,iris$Sepal.Width)

}
