% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignSurvivals.R
\name{pwexpcuts}
\alias{pwexpcuts}
\title{Piecewise Exponential Approximation to a Survival Distribution}
\usage{
pwexpcuts(S, ..., tol = 1e-04)
}
\arguments{
\item{S}{The survival function of a univariate survival time.}

\item{...}{Additional arguments to be passed to S.}

\item{tol}{The tolerance for convergence of the profile log-likelihood.
Defaults to 0.0001.}
}
\value{
A list with three components:
\itemize{
\item \code{piecewiseSurvivalTime}: A vector that specifies the starting
time of piecewise exponential survival time intervals.
Must start with 0, e.g., c(0, 6) breaks the time axis into 2 event
intervals: [0, 6) and [6, Inf).
\item \code{lambda}: A vector of hazard rates for the event. One for
each analysis time interval.
\item \code{loglik}: The sequence of the asymptotic limit of the
piecewise exponential log-likelihood for an increasing number
of change points.
}
}
\description{
Obtains the piecewise exponential distribution that
approximates a survival distribution.
}
\details{
This function computes the piecewise exponential approximation
to a survival distribution.
The piecewise exponential model divides the time axis into
\eqn{J} intervals defined by the change points, where each
interval \eqn{[t_j, t_{j+1})} has a constant hazard rate
\eqn{\lambda_j}. The time intervals are specified as:
\deqn{[t_1, t_2), [t_2, t_3), \ldots, [t_{J}, t_{J+1})}
where \eqn{t_1 = 0}, \eqn{t_{J+1} = \infty}, and
\eqn{t_j = \tau_{j-1}} for \eqn{j = 2, \ldots, J}.
The function starts with \eqn{J = 2} (1 change point) and
gradually increases \eqn{J} by adding one change point at a time
until the maximized profile log-likelihood for change points
stabilizes, i.e., the relative increase in the maximum of the
profile log-likelihood function is less than \code{tol}.
If the relative change in the hazard rate is also less than
\code{tol}, the function stops and returns the results.
}
\examples{

# Example 1: Piecewise exponential
pwexpcuts(ptpwexp, piecewiseSurvivalTime = c(0, 3.4, 5.5),
          lambda = c(0.0168, 0.0833, 0.0431), lowerBound = 0,
          lower.tail = FALSE)

# Example 2: Weibull
pwexpcuts(pweibull, shape = 1.37, scale = 1/0.818, lower.tail = FALSE)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
