% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index.R
\name{_index_}
\alias{_index_}
\alias{magick}
\alias{magick-package}
\alias{imagemagick}
\title{Magick Image Processing}
\description{
The \code{magick} package for graphics and image processing in R. Important resources:
\itemize{
\item \href{https://docs.ropensci.org/magick/articles/intro.html}{R introduction vignette}: getting started
\item \href{https://imagemagick.org/Magick++/Image++.html}{Magick++ API} and
\href{https://imagemagick.org/Magick++/STL.html}{Magick++ STL} detailed descriptions of methods and parameters
}
}
\details{
Documentation is split into the following pages:
\itemize{
\item \link{analysis} - metrics and calculations: \code{compare}, \code{fft}
\item \link{animation} - manipulate or combine multiple frames: \code{animate},
\code{morph}, \code{mosaic}, \code{montage}, \code{average}, \code{append}, \code{apply}
\item \link{attributes} - image properties: \code{comment}, \code{info}
\item \link{color} - contrast, brightness, colors: \code{modulate}, \code{quantize}, \code{map}, \code{transparent},
\code{background}, \code{colorize}, \code{contrast}, \code{normalize}, \code{enhance}, \code{equalize}, \code{median}
\item \link{composite} - advanced joining: \code{composite}, \code{border}, \code{frame}
\item \link{device} - creating graphics and drawing on images
\item \link{editing} - basic image IO: \code{read}, \code{write}, \code{convert}, \code{join}, \code{display}, \code{brose}
\item \link{effects} - fun effects: \code{despecle}, \code{reducenoise}, \code{noise}, \code{blur}, \code{charcoal},
\code{edge}, \code{oilpaint}, \code{emboss}, \code{implode}, \code{negate}
\item \link{geometry} - specify points, areas and sizes using geometry syntax
\item \link{ocr} - extract text from image using \link[tesseract:tesseract]{tesseract} package
\item \link{options} - list option types and values supported in your version of ImageMagick
\item \link{painting} - flood fill and annotating text
\item \link{transform} - shape operations: \code{trim}, \code{chop}, \code{rotate}, \code{resize}, \code{scale}, \code{sample}
\code{crop}, \code{flip}, \code{flop}, \code{deskew}, \code{page}
}
}
\seealso{
Other image: 
\code{\link{analysis}},
\code{\link{animation}},
\code{\link{attributes}()},
\code{\link{color}},
\code{\link{composite}},
\code{\link{defines}},
\code{\link{device}},
\code{\link{edges}},
\code{\link{editing}},
\code{\link{effects}()},
\code{\link{fx}},
\code{\link{geometry}},
\code{\link{morphology}},
\code{\link{ocr}},
\code{\link{options}()},
\code{\link{painting}},
\code{\link{segmentation}},
\code{\link{transform}()},
\code{\link{video}}
}
\concept{image}
