% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct.R
\name{bespoke_rmd_initialise_widgets}
\alias{bespoke_rmd_initialise_widgets}
\title{Initialise HTML widgets}
\usage{
bespoke_rmd_initialise_widgets(plot_type)
}
\arguments{
\item{plot_type}{"\code{bar}" or "\code{line}", depending on what will be used in real
tables. Or "none" if just want a reactable widget without dygraphs e.g. for
alerts}
}
\value{
A (mostly) invisible html widget
}
\description{
Since the output is being constructed in \code{results='asis'} chunks, there must
also be at least one standard chunk that contains the relevant widgets,
otherwise they will fail to render. The \code{dygraph} also needs to be
initialised with the appropriate \code{plot_type}. This is only needed when
creating interactive reports. Make sure you read the vignette:
\code{vignette("bespoke-reports", package = "mantis")} as it contains further
important information. Note: The chunk currently appears like a line break
when rendered. See \url{https://github.com/rstudio/rmarkdown/issues/1877} for
more info.
}
\examples{
\dontrun{
# put this inside its own chunk in the rmd file
# it ensures that the dygraphs render when built using `cat()`
# set the plot_type to the same plot_type as the real output
mantis::bespoke_rmd_initialise_widgets(plot_type = "bar")
}

}
