/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.set;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.set.AbstractLargeSetIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.set.SetVar;

public final class InverseSetInt
extends AbstractLargeSetIntSConstraint {
    boolean init = true;

    public InverseSetInt(IntDomainVar[] x, SetVar[] s) {
        super(x, s);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (this.isSetVarIndex(idx)) {
            return 7;
        }
        return 12;
    }

    public void filterFromIndices() throws ContradictionException {
        int n = this.getNbSetVars() - 1;
        for (int j = 0; j < this.ivars.length; ++j) {
            this.ivars[j].updateInf(0, this, false);
            this.ivars[j].updateSup(n, this, false);
        }
        n = this.getNbIntVars() - 1;
        for (int i = 0; i < this.svars.length; ++i) {
            while (this.svars[i].getEnveloppeInf() < 0) {
                this.svars[i].remFromEnveloppe(this.svars[i].getEnveloppeInf(), this, false);
            }
            while (this.svars[i].getEnveloppeSup() > n) {
                this.svars[i].remFromEnveloppe(this.svars[i].getEnveloppeSup(), this, false);
            }
        }
    }

    @Override
    public void awake() throws ContradictionException {
        this.filterFromIndices();
        super.awake();
    }

    @Override
    public void awakeOnKer(int i, int j) throws ContradictionException {
        assert (this.isSetVarIndex(i));
        this.ivars[j].instantiate(i, this, true);
    }

    @Override
    public void awakeOnEnv(int i, int j) throws ContradictionException {
        assert (this.isSetVarIndex(i));
        this.ivars[j].removeVal(i, this, false);
    }

    private void filterSetVar(int i) throws ContradictionException {
        for (int j = 0; j < this.getNbIntVars(); ++j) {
            if (this.svars[i].isInDomainKernel(j)) {
                this.ivars[j].instantiate(i, this, true);
                continue;
            }
            if (this.svars[i].isInDomainEnveloppe(j)) continue;
            this.ivars[j].removeVal(i, this, false);
        }
    }

    @Override
    public void awakeOnInst(int x) throws ContradictionException {
        if (this.isSetVarIndex(x)) {
            this.filterSetVar(x);
        } else {
            int i;
            int iv = this.getIntVarIndex(x);
            int s = this.ivars[iv].getVal();
            this.svars[s].addToKernel(iv, this, false);
            for (i = 0; i < s; ++i) {
                this.svars[i].remFromEnveloppe(iv, this, false);
            }
            for (i = s + 1; i < this.svars.length; ++i) {
                this.svars[i].remFromEnveloppe(iv, this, false);
            }
        }
    }

    @Override
    public void awakeOnRem(int x, int v) throws ContradictionException {
        if (this.isSetVarIndex(x)) {
            this.awakeOnEnv(x, v);
        } else {
            this.svars[v].remFromEnveloppe(this.getIntVarIndex(x), this, false);
        }
    }

    public void awakeOnVar(int x) throws ContradictionException {
        if (this.getVar(x).isInstantiated()) {
            this.awakeOnInst(x);
        } else if (this.isSetVarIndex(x)) {
            this.filterSetVar(x);
        } else {
            int iv = this.getIntVarIndex(x);
            for (int i = 0; i < this.svars.length; ++i) {
                if (this.ivars[iv].canBeInstantiatedTo(i)) continue;
                this.svars[i].remFromEnveloppe(iv, this, false);
            }
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        for (int x = 0; x < this.getNbVars(); ++x) {
            this.awakeOnVar(x);
        }
    }

    public boolean isSatisfied(int j) {
        int s = this.ivars[j].getVal();
        if (!this.svars[s].isInDomainKernel(j)) {
            return false;
        }
        for (int i = 0; i < this.svars.length; ++i) {
            if (!this.svars[i].isInDomainEnveloppe(j) || i == s) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSatisfied() {
        for (int j = 0; j < this.getNbIntVars(); ++j) {
            if (this.isSatisfied(j)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isConsistent() {
        for (int j = 0; j < this.ivars.length; ++j) {
            if (this.ivars[j].isInstantiated()) {
                if (this.isSatisfied(j)) continue;
                return false;
            }
            for (int i = 0; i < this.svars.length; ++i) {
                if (!(!this.ivars[j].canBeInstantiatedTo(i) ? this.svars[i].isInDomainEnveloppe(j) : this.svars[i].isInDomainKernel(j) || !this.svars[i].isInDomainEnveloppe(j))) continue;
                return false;
            }
        }
        return true;
    }
}

