/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search.checker;

import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.search.checker.ISolutionCheckerEngine;
import choco.kernel.solver.search.checker.SolutionCheckerException;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.real.RealVar;
import choco.kernel.solver.variables.set.SetVar;
import java.util.logging.Level;

public abstract class AbstractSolutionCheckerEngine
implements ISolutionCheckerEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void checkConstraints(Solver solver) throws SolutionCheckerException {
        DisposableIterator<SConstraint> ctit = solver.getConstraintIterator();
        try {
            while (ctit.hasNext()) {
                this.checkConstraint((SConstraint)ctit.next());
            }
        }
        finally {
            ctit.dispose();
        }
    }

    @Override
    public void checkSolution(Solver solver) throws SolutionCheckerException {
        this.checkVariables(solver);
        this.checkConstraints(solver);
    }

    @Override
    public final void checkVariables(Solver solver) throws SolutionCheckerException {
        DisposableIterator<IntDomainVar> ivIter = solver.getIntVarIterator();
        while (ivIter.hasNext()) {
            this.checkVariable((Var)ivIter.next());
        }
        ivIter.dispose();
        DisposableIterator<SetVar> svIter = solver.getSetVarIterator();
        while (svIter.hasNext()) {
            this.checkVariable((Var)svIter.next());
        }
        svIter.dispose();
        DisposableIterator<RealVar> rvIter = solver.getRealVarIterator();
        while (rvIter.hasNext()) {
            this.checkVariable((Var)rvIter.next());
        }
        rvIter.dispose();
    }

    @Override
    public final boolean inspectConstraints(Solver solver) {
        boolean isOk = true;
        DisposableIterator<SConstraint> ctit = solver.getConstraintIterator();
        while (ctit.hasNext()) {
            isOk &= this.inspectConstraint((SConstraint)ctit.next());
        }
        ctit.dispose();
        return isOk;
    }

    @Override
    public boolean inspectSolution(Solver solver) {
        LOGGER.log(Level.CONFIG, "- Check solution: {0}", this.getClass().getSimpleName());
        boolean isOk = true;
        if (this.inspectVariables(solver)) {
            LOGGER.config("- Check solution: Every variable is instantiated.");
        } else {
            isOk = false;
            LOGGER.severe("- Check solution: Some variables are not instantiated.");
        }
        if (this.inspectConstraints(solver)) {
            LOGGER.config("- Check solution: Every constraint is satisfied.");
        } else {
            isOk = false;
            LOGGER.severe("- Check solution: Some constraints are not satisfied.");
        }
        return isOk;
    }

    @Override
    public final boolean inspectVariables(Solver solver) {
        boolean isOk = true;
        DisposableIterator<IntDomainVar> ivIter = solver.getIntVarIterator();
        while (ivIter.hasNext()) {
            isOk &= this.inspectVariable((Var)ivIter.next());
        }
        ivIter.dispose();
        DisposableIterator<SetVar> svIter = solver.getSetVarIterator();
        while (svIter.hasNext()) {
            isOk &= this.inspectVariable((Var)svIter.next());
        }
        svIter.dispose();
        DisposableIterator<RealVar> rvIter = solver.getRealVarIterator();
        while (rvIter.hasNext()) {
            isOk &= this.inspectVariable((Var)rvIter.next());
        }
        rvIter.dispose();
        return isOk;
    }
}

