% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_graph.R
\name{with_graph}
\alias{with_graph}
\title{Evaluate Causal Graph Discovery Algorithm in Multiple Imputed Data sets}
\usage{
with_graph(data, algo = c("pc", "fci", "fciPlus", "ges"), args, score = FALSE)
}
\arguments{
\item{data}{An object of type mids, which stands for 'multiply imputed
data set', typically created by a call to function mice()}

\item{algo}{An algorithm for causal discovery from the package 'pcalg'
(see details).}

\item{args}{Additional arguments passed to the algo. Must be a string
vector starting with comma, i.e. ", ..."}

\item{score}{Logical indicating whether a score-based or a constrained-based
algorithm is applied.}
}
\value{
A list object of S3 class \code{mice::\link[mice]{mira-class}}.
}
\description{
Evaluate Causal Graph Discovery Algorithm in Multiple Imputed Data sets
}
\examples{
data(windspeed)
dat <- as.matrix(windspeed)

## delete some observations
set.seed(123)
dat[sample(1:length(dat), 260)] <- NA

## Impute missing values under normal model
imp <- mice(dat, method = "norm", printFlag = FALSE)
out.fci <- with_graph(data = imp, 
                      algo = "fciPlus", 
                      args = ", indepTest = gaussCItest, verbose = FALSE,
                      labels = names(imp$imp), alpha = 0.01")
                          
 out.ges <- with_graph(data = imp, algo = "ges", arg = NULL, score = TRUE)
 
if (requireNamespace("Rgraphviz", quietly = TRUE)){
 oldpar <- par(mfrow = c(1,2)) 
   plot(out.fci$res[[1]])
   plot(out.ges$res[[1]]$essgraph)
 par(oldpar)
 }
                                     
}
