% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_fm.R, R/kfm_exact.R, R/kfm_nystrom.R
\name{build_fm}
\alias{build_fm}
\alias{build_fm.kfm_exact}
\alias{build_fm.kfm_nystrom}
\title{Build a feature map on new data}
\usage{
build_fm(kfm_fit, new_data, ...)

\method{build_fm}{kfm_exact}(kfm_fit, new_data, ...)

\method{build_fm}{kfm_nystrom}(kfm_fit, new_data, ...)
}
\arguments{
\item{kfm_fit}{An object from a function in the \verb{kfm_*} family, such as
\code{\link[=kfm_nystrom]{kfm_nystrom()}}.}

\item{new_data}{The data to generate features from.}

\item{...}{Additional arguments for methods.}
}
\value{
A matrix of covariates in the feature space, with the same number of
rows as \code{new_data}.  If \code{new_data} is a \code{mild_df} object, \code{build_fm()}
will also return the columns containing 'bag_label', 'bag_name',
'instance_name'.
}
\description{
Feature maps provide a set of covariates in a transformed space.  The
\code{build_fm()} function creates these covariates based on an object that
specifies the feature map and a provided dataset.
}
\section{Methods (by class)}{
\itemize{
\item \code{build_fm(kfm_exact)}: Method for \code{kfm_exact} class.

\item \code{build_fm(kfm_nystrom)}: Method for \code{kfm_nystrom} class.

}}
\examples{
df <- data.frame(
  X1 = c(2,   3,   4,   5,   6, 7, 8),
  X2 = c(1, 1.2, 1.3, 1.4, 1.1, 7, 1),
  X3 = rnorm(7)
)

fit <- kfm_nystrom(df, m = 7, r = 6, kernel = "radial", sigma = 0.05)
fm <- build_fm(fit, df)

fit <- kfm_exact(kernel = "polynomial", degree = 2, const = 1)
fm <- build_fm(fit, df)

}
\seealso{
\itemize{
\item \code{\link[=kfm_nystrom]{kfm_nystrom()}} fit a Nystrom kernel feature map approximation.
\item \code{\link[=kfm_exact]{kfm_exact()}} create an exact kernel feature map.
}
}
\author{
Sean Kent
}
