% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FORM.R
\name{FORM}
\alias{FORM}
\title{First-order reliability method}
\usage{
FORM(
  dimension,
  lsf,
  u.dep = rep(0, dimension),
  N.calls = 100,
  eps = 1e-07,
  Method = "HLRF",
  IS = FALSE,
  IS.ratio = 0.5,
  plot = FALSE,
  plot.lsf = FALSE,
  plot.lab = c("x_1", "x_2")
)
}
\arguments{
\item{dimension}{the dimension of the input space.}

\item{lsf}{the limit-state function.}

\item{u.dep}{the starting point for the MPFP search.}

\item{N.calls}{the total number of calls for the whole algorithm.}

\item{eps}{stopping criterion: distance of two points between two iterations.}

\item{Method}{choice of the method to search the design point: "AR" for Abdo-Rackwitz
and "HLRF" for Hasofer-Lindt-Rackwitz-Fiessler.}

\item{IS}{"TRUE" for using importance Sampling method with an standard Gaussian importance
density centred at the MPFP.}

\item{IS.ratio}{ratio of N.calls for the search of the design point by FORM. Default = 0.5.
1-\code{IS.ratio} = the remaining ratio to be used for importance sampling.}

\item{plot}{to plot the generated samples.}

\item{plot.lsf}{a boolean indicating if the \code{lsf} should be added to the
plot. This requires the evaluation of the \code{lsf} over a grid and
consequently should be used only for illustation purposes.}

\item{plot.lab}{the x and y labels for the plot.}
}
\value{
A list containing the following objects
\item{p}{Failure probability}
\item{indice.reliab}{Reliability index}
\item{Ncall}{Number of calls to f}
\item{Design.Point}{Coordinates of the design point}
\item{fact.imp}{Importance factors}
\item{variance}{Standard error of the probability estimator (if IS = TRUE)}
\item{Interval.conf}{Confidence interval of the estimator at 0.95 (if IS = TRUE)}
\item{DOE}{List which contains the design of experiments}
}
\description{
The First-Order Reliability Method computes an estimation of the failure
probability by approximating the limit-state function at the Most Probable Failure Point
with a hyperplane.
}
\details{
The FORM method has to be used in the standard Gaussian input space. It is designed
to estimate probability of the form \eqn{P[g(\mathbf{X}) < 0]}{P[g(X) < 0]} with g the limit-state function.
This function has to be modified accordingly to fit into this framework

Furthermore, it should be able to handle matrix input of column vectors. See the mistral vignette
for more info about \code{lsf} definition
}
\examples{
\dontrun{
# u.dep is a starting point for the research of the Most Probable Failing Point
# N.calls is a total number of calls
form <- mistral::FORM(dimension = 2, mistral::kiureghian, N.calls = 1000,
                     u.dep = c(0,0))
form$p

# use IS=TRUE to use an Importance Sampling scheme with a Gaussian standard
# proposal distribution centred at the MPFP
form.IS <- mistral::FORM(dimension = 2, mistral::kiureghian, N.calls = 1000,
                        u.dep = c(0,0),
                        IS = TRUE)
form.IS$p
}

}
\references{
\itemize{
\item
O. Ditlevsen and H.O. Madsen. Structural reliability methods, Wiley, 1996\cr
\item
M. Lemaire, A. Chateauneuf and J. Mitteau. Structural reliability, Wiley Online Library, 2009.\cr
}
}
\author{
Vincent MOUTOUSSAMY and Clement WALTER \email{clementwalter@icloud.com}
}
