% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavelet.R
\name{analyze_coherency}
\alias{analyze_coherency}
\title{Analyze Coherency from View object}
\usage{
analyze_coherency(
  obj,
  columns,
  loess.span = 0,
  dj = 1/50,
  lowerPeriod = 2/obj$recording$fps,
  upperPeriod = 5,
  window.type.t = 1,
  window.type.s = 1,
  window.size.t = 5,
  window.size.s = 1/4,
  make.pval = TRUE,
  method = "white.noise",
  params = NULL,
  n.sim = 1,
  date.format = NULL,
  date.tz = NULL,
  verbose = FALSE
)
}
\arguments{
\item{obj}{View object.}

\item{columns}{Two column names.}

\item{loess.span}{parameter alpha in loess controlling the degree of time series smoothing, if the time series is to be detrended; no detrending if loess.span = 0.
Default: 0.}

\item{dj}{frequency resolution. Default 1/20.}

\item{lowerPeriod}{in seconds}

\item{upperPeriod}{in seconds}

\item{window.type.t}{see \code{\link[WaveletComp:analyze.coherency]{WaveletComp::analyze.coherency()}}.}

\item{window.type.s}{see \code{\link[WaveletComp:analyze.coherency]{WaveletComp::analyze.coherency()}}.}

\item{window.size.t}{see \code{\link[WaveletComp:analyze.coherency]{WaveletComp::analyze.coherency()}}.}

\item{window.size.s}{see \code{\link[WaveletComp:analyze.coherency]{WaveletComp::analyze.coherency()}}.}

\item{make.pval}{see \code{\link[WaveletComp:analyze.coherency]{WaveletComp::analyze.coherency()}}.}

\item{method}{see \code{\link[WaveletComp:analyze.coherency]{WaveletComp::analyze.coherency()}}.}

\item{params}{see \code{\link[WaveletComp:analyze.coherency]{WaveletComp::analyze.coherency()}}.}

\item{n.sim}{number of simulations (default 1).}

\item{date.format}{see \code{\link[WaveletComp:analyze.coherency]{WaveletComp::analyze.coherency()}}.}

\item{date.tz}{see \code{\link[WaveletComp:analyze.coherency]{WaveletComp::analyze.coherency()}}.}

\item{verbose}{see \code{\link[WaveletComp:analyze.coherency]{WaveletComp::analyze.coherency()}}.}
}
\value{
an \code{analyze_coherency} object.
}
\description{
Analyze Coherency from View object
}
\examples{

r <- get_sample_recording()
rv <- get_raw_view(r, "Central", "", "Sitar")
pv <- get_processed_view(rv)
co <- analyze_coherency(pv, c("Nose_x", "Nose_y"))

}
\seealso{
Other wavelet functions: 
\code{\link{analyze_wavelet}()},
\code{\link{get_local_max_average_power}()},
\code{\link{plot_average_coherency}()},
\code{\link{plot_average_power}()},
\code{\link{plot_cross_spectrum}()},
\code{\link{plot_cwt_energy}()},
\code{\link{plot_phase_difference}()},
\code{\link{plot_power_spectrum}()},
\code{\link{plot_roll_resultant_length}()},
\code{\link{plot_sel_phases}()},
\code{\link{plot_wt_energy}()}
}
\concept{wavelet functions}
