% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splice.R
\name{clip_splice}
\alias{clip_splice}
\title{Clip a splice so segments are of fixed duration}
\usage{
clip_splice(splice_dfr, duration, location = "middle")
}
\arguments{
\item{splice_dfr}{\code{Splice} object.}

\item{duration}{window duration in seconds.}

\item{location}{'beginning', 'middle' or 'end'.}
}
\value{
a \code{Splice} object.
}
\description{
Clip a splice so segments are of fixed duration
}
\examples{
l <- list(a = c(10, 20), b = c(30, 40),c = c(50, 55))
splice_dfr <- splice_time(l)
clip_splice(splice_dfr, duration = 1)
clip_splice(splice_dfr, duration = 6)
clip_splice(splice_dfr, duration = 1, location = 'beginning')
clip_splice(splice_dfr, duration = 10, location = 'beginning')
clip_splice(splice_dfr, duration = 1, location = 'end')
clip_splice(splice_dfr, duration = 10, location = 'end')
}
\seealso{
Other splicing functions: 
\code{\link{get_spliced_view}()},
\code{\link{is_splice_overlapping}()},
\code{\link{merge_splice}()},
\code{\link{splice_time}()},
\code{\link{splice_time.Duration}()},
\code{\link{splice_time.Metre}()},
\code{\link{splice_time.OnsetsDifference}()},
\code{\link{splice_time.View}()},
\code{\link{splice_time.list}()},
\code{\link{split.SplicedView}()}
}
\concept{splicing functions}
