% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_diagnostics.R
\name{xlim_duration}
\alias{xlim_duration}
\title{Get a ggplot2 xlim object based on duration data}
\usage{
xlim_duration(object, expr = .data$Tier == "Form")
}
\arguments{
\item{object}{Duration object.}

\item{expr}{R expression to subset rows.}
}
\value{
a 'Duration' object.
}
\description{
Get a ggplot2 xlim object based on duration data
}
\examples{
\donttest{
r<-get_recording("NIR_ABh_Puriya", fps=25)
m <- get_metre_data(r)
d <- get_duration_annotation_data(r)
autoplot(m)
autoplot(m) + autolayer(d)
v <- get_raw_view(r, "Central", "", "Sitar")
autoplot(v, columns = c("LEar_x", "LEar_y")) + autolayer(d)
autoplot(v, columns = c("LEar_x", "LEar_y")) +
xlim_duration(d, expr = Tier == "FORM" & substr(Comments, 1, 1) == "J") +
autolayer(d, expr = Tier == "FORM" & substr(Comments, 1, 1) == "J")
}
}
