% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_gaz_types.R
\name{gaz_search_by_type}
\alias{gaz_search_by_type}
\alias{gaz_search_by_type.character}
\alias{gaz_search_by_type.numeric}
\title{Retrieve Gazetteer Records by Placetype}
\usage{
gaz_search_by_type(x, ...)

\method{gaz_search_by_type}{character}(x, ...)

\method{gaz_search_by_type}{numeric}(x, ...)
}
\arguments{
\item{x}{A \link[=gaz_types]{place type}. Either:
\itemize{
\item (character) The name of a place type.
\item (integer) The typeid of a place type.
}}

\item{...}{
  Arguments passed on to \code{\link[=gaz_rest_records_by_type]{gaz_rest_records_by_type}}
  \describe{
    \item{\code{type}}{(character) The placetype from \code{\link[=gaz_rest_types]{gaz_rest_types()}}}
    \item{\code{with_geometry}}{(logical) Add geometries to the result data frame? Default = FALSE}
  }}
}
\value{
A data frame with Gazetteer entries
}
\description{
Retrieve Gazetteer Records by Placetype
}
\examples{
\donttest{
# This
gaz_search_by_type("EEZ")

# is the same as
gaz_search_by_type(70)
}
}
\seealso{
\code{\link[=gaz_types]{gaz_types()}}
}
