% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file-mapping.R
\name{file_mapping}
\alias{file_mapping}
\title{Create a file mapping for multi-repository deployment}
\usage{
file_mapping(
  ...,
  dir = NULL,
  pattern = NULL,
  target_prefix = "",
  preserve_structure = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{...}{Named arguments where names are local file paths and values are repository paths}

\item{dir}{Character string specifying a directory to search for files. Default is NULL.}

\item{pattern}{Character string with a regular expression pattern to match files in dir. Default is NULL.}

\item{target_prefix}{Character string to prefix to all target paths. Default is "".}

\item{preserve_structure}{Logical indicating whether to preserve directory structure in target. Default is FALSE.}

\item{quiet}{Logical; if TRUE, suppresses information messages. Default is FALSE.}
}
\value{
Returns an object of class \code{"file_mapping"} (which is just a marked up \code{"list"}) containing:
\itemize{
\item A named list where each entry maps a local file path (name) to a target repository path (value)
\item Each key is the full path to a local file
\item Each value is the corresponding path where the file should be placed in repositories
}
}
\description{
This function builds a mapping between local files and their target paths in repositories,
supporting both individual file mapping and bulk directory processing.
}
\details{
The \code{dir} argument requires a valid directory path currently on the local filesystem.
This directory is scanned for files matching the \code{pattern} regular expression,
and each file is mapped to a target path in repositories. If the directory is
not found, an error is thrown.
}
\examples{
# Map individual files with explicit source-to-target paths
mapping <- file_mapping(
  "local/path/ci.yml" = ".github/workflows/ci.yml",
  "local/path/lint.R" = ".lintr"
)

# Automatically map all R files from a directory to backup/R2/
workflow_mapping <- file_mapping(
  dir = system.file(package = "multideploy"),
  pattern = "\\\\.R$",
  target_prefix = "backup/R2/"
)

# Preserve directory structure when mapping files
template_mapping <- file_mapping(
  dir = system.file(package = "multideploy"),
  preserve_structure = TRUE
)

# Combine explicit mappings with directory-based mappings
combined_mapping <- file_mapping(
  "specific/file.R" = "R/functions.R",
  dir = system.file(package = "multideploy"),
  target_prefix = ".github/"
)
}
\seealso{
\code{\link[=print.file_mapping]{print.file_mapping()}} to display the mapping in a formatted way.
}
