% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-pipeline.R
\name{add_correlations}
\alias{add_correlations}
\title{Add correlations from the \code{correlation} package in \code{easystats}}
\usage{
add_correlations(
  .df,
  var_set,
  variables,
  focus_set = NULL,
  method = "auto",
  redundant = TRUE,
  add_matrix = TRUE
)
}
\arguments{
\item{.df}{the original \code{data.frame}(e.g., base data set). If part of
set of
add_* decision functions in a pipeline, the base data will be passed along
as an attribute.}

\item{var_set}{character string. Should be a descriptive name of the
correlation matrix.}

\item{variables}{the variables for which you would like to correlations.
These variables will be passed to \code{link[correlation]{correlation}}.
You can also use tidyselect to select variables.}

\item{focus_set}{variables to focus one in a table. This produces a table
where rows are each focused variables and columns are all other variables}

\item{method}{a valid method of correlation supplied to
\code{link[correlation]{correlation}} (e.g., 'pearson' or 'kendall').
Defaults to \code{'auto'}. See \code{link[correlation]{correlation}} for
more details.}

\item{redundant}{logical, should the result include repeated correlations?
Defaults to \code{TRUE} See \code{link[correlation]{correlation}} for
details.}

\item{add_matrix}{logical, add a traditional correlation matrix to the
output. Defaults to \code{TRUE}.}
}
\value{
a \code{data.frame}with three columns: type, group, and code. Type
indicates the decision type, group is a decision, and the code is the
actual code that will be executed. If part of a pipe, the current set of
decisions will be appended as new rows.
}
\description{
Add correlations from the \code{correlation} package in \code{easystats}
}
\examples{

library(tidyverse)
library(multitool)

the_data <-
  data.frame(
    id   = 1:500,
    iv1  = rnorm(500),
    iv2  = rnorm(500),
    iv3  = rnorm(500),
    mod1 = rnorm(500),
    mod2 = rnorm(500),
    mod3 = rnorm(500),
    cov1 = rnorm(500),
    cov2 = rnorm(500),
    dv1  = rnorm(500),
    dv2  = rnorm(500),
    include1 = rbinom(500, size = 1, prob = .1),
    include2 = sample(1:3, size = 500, replace = TRUE),
    include3 = rnorm(500)
  )

the_data |>
  add_filters(include1 == 0,include2 != 3,include2 != 2, include3 > -2.5) |>
  add_variables("ivs", iv1, iv2, iv3) |>
  add_variables("dvs", dv1, dv2) |>
  add_variables("mods", starts_with("mod")) |>
  add_correlations("predictors", matches("iv|mod|cov"), focus_set = c(cov1,cov2))
}
