#' GAM instance for MWCS problem
#'
#' A dataset containing some real-world instances appeared in network
#' enrichment analysis tool Shiny GAM
#' (\doi{10.1093/nar/gkw266}).
#'
#' @format A vector of named vertex-weighted igraph instances
#' @source \url{http://dimacs11.zib.de/instances/MWCS-GAM.zip}
"gam_example"

#' Example MWCS instance
#'
#' Instance is based on `gatom` package.
"mwcs_example"

#' Example GMWCS instance
#'
#' Instance is based on `gatom` package.
"gmwcs_example"

#' Example SGMWCS instance
#'
#' Instance is based on `gatom` package.
"sgmwcs_example"


#' Example MWCS instance obtained from BioNet package tutorial
#'
"bionet_example"

#' Example of graph from which an SGMWCS instance can be obtained
#'
#' The graph is based on `gatom` package
"gatom_example"

#' Small example of MWCS instance for demonstration purposes.
"mwcs_small_instance"

#' Small example of GMWCS instance for demonstration purposes.
"gmwcs_small_instance"

#' Small example of SGMWCS instance for demonstration purposes.
"sgmwcs_small_instance"
