% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSquadpq.R
\name{SSquadpq}
\alias{SSquadpq}
\alias{quadpq}
\title{self start for quadratic-plateau-quadratic (QPQ) function}
\usage{
quadpq(x, a, b, xs, ldxs)

SSquadpq(x, a, b, xs, ldxs)
}
\arguments{
\item{x}{input vector}

\item{a}{the intercept}

\item{b}{the slope}

\item{xs}{first break-point}

\item{ldxs}{log of the difference between break-point and second break-point}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

quadpq: vector of the same length as x using the quadratic-plateau-quadratic function
}
\description{
Self starter for quadratic plateau function with (four) parameters a (intercept), b (slope), xs (break-point), ldxs (log of the difference between break-point and second break-point)
}
\details{
The equation is, for a response (y) and a predictor (x): \cr
  \deqn{y ~ (x <= xs) * (a + b * x + (-0.5 * b/xs) * x^2) + 
  (x > xs \text{\&} x <= (xs + dxs)) * (a + (-b^2)/(4 * -0.5 * b/xs)) + 
  (x > (xs + dxs)) * ((a + (-b^2)/(4 * -0.5 * b/xs)) + ((-0.5 * b/xs) * (x - (xs + dxs))^2))} \cr
  
 This is a somewhat complicated equation. The interpretation of the parameters are simple.
 The model is parameterized in terms of the log of dxs (or ldxs). The parameter is ensured
 to be positive by taking the exponential.
}
\examples{
\donttest{
require(ggplot2)
set.seed(123)
x <- 0:25
y <- quadpq(x, 1, 0.5, 10, 1.5) + rnorm(length(x), 0, 0.3)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSquadpq(x, a, b, xs, dxs), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit))) + 
  geom_vline(aes(xintercept = coef(fit)[3]), linetype = 2) +
  geom_vline(aes(xintercept = coef(fit)[3] + exp(coef(fit)[4])), linetype = 3)
     
}
}
