% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quaisDimensoes.R
\name{quaisMembros}
\alias{quaisMembros}
\title{List of Members in a Brazilian Federal Budget Dimension.}
\usage{
quaisMembros(
  exercicio = .last_year(),
  dimensao,
  ignoreSecureCertificate = FALSE
)
}
\arguments{
\item{exercicio}{A number. Indicates the year to which the extracted data refers. (Indica o ano a que se refere a extração)}

\item{dimensao}{A string. The dimension to be listed. (A dimensão a ser relacionada)
Valid values (Valores válidos): \link{dimensoes}}

\item{ignoreSecureCertificate}{A Boolean. If the parameter is set to \code{TRUE},
the download of SIOP data will proceed while ignoring the secure certificate.
(Se o parâmetro estiver definido como \code{TRUE}, o download dos dados
do SIOP será realizado ignorando o certificado seguro.)}
}
\value{
The dataframe contains the members in a dimension. Both code and description are provided.
}
\description{
This function lists all members in a Brazilian Federal Budget dimension for a given year.
}
\examples{
\dontrun{quaisMembros(2023, dimensao = "Funcao")}

}
