% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outpack_config.R
\name{orderly_config}
\alias{orderly_config}
\title{Read configuration}
\usage{
orderly_config(root = NULL)
}
\arguments{
\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function does not require that the directory is
configured for orderly, and can be any \code{outpack} root (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
A list of configuration options:
\itemize{
\item \code{core}: The most important options about the outpack store, containing:
\itemize{
\item \code{path_archive}: The path to the human-readable packet archive,
or \code{NULL} if disabled (set in \code{\link[=orderly_config_set]{orderly_config_set()}} as
\code{core.path_archive})
\item \code{use_file_store}: Indicates if a content-addressable file store
is enabled (\code{core.use_file_store})
\item \code{require_complete_tree}: Indicates if this outpack store requires
all dependencies to be fully available (\code{core.require_complete_tree})
\item \code{hash_algorithm}: The hash algorithm used (currently not modifiable)
}
\item \code{location}: Information about locations; see
\code{\link[=orderly_location_add]{orderly_location_add()}},
\code{\link[=orderly_location_rename]{orderly_location_rename()}} and
\code{\link[=orderly_location_remove]{orderly_location_remove()}} to interact with this
configuration, or \code{\link[=orderly_location_list]{orderly_location_list()}} to more
simply list available locations. Returns as a \link{data.frame} with
columns \code{name}, \code{id}, \code{priority}, \code{type} and \code{args}, with \code{args}
being a list column.
\item \code{orderly}: A list of orderly-specific configuration; this is
just the minimum required version (as
\code{minimum_orderly_version}).
}
}
\description{
Read the current orderly configuration, stored within the outpack
root, along with any orderly-specific extensions.
}
\examples{

# A default configuration in a new temporary directory
path <- withr::local_tempdir()
orderly_init(path)
orderly_config(path)
}
