# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include pinpointemail_service.R
NULL

#' Create a configuration set
#'
#' @description
#' Create a configuration set. *Configuration sets* are groups of rules that you can apply to the emails you send using Amazon Pinpoint. You apply a configuration set to an email by including a reference to the configuration set in the headers of the email. When you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_create_configuration_set/](https://www.paws-r-sdk.com/docs/pinpointemail_create_configuration_set/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set.
#' @param TrackingOptions An object that defines the open and click tracking options for emails
#' that you send using the configuration set.
#' @param DeliveryOptions An object that defines the dedicated IP pool that is used to send emails
#' that you send using the configuration set.
#' @param ReputationOptions An object that defines whether or not Amazon Pinpoint collects
#' reputation metrics for the emails that you send that use the
#' configuration set.
#' @param SendingOptions An object that defines whether or not Amazon Pinpoint can send email
#' that you send using the configuration set.
#' @param Tags An array of objects that define the tags (keys and values) that you want
#' to associate with the configuration set.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_create_configuration_set
pinpointemail_create_configuration_set <- function(ConfigurationSetName, TrackingOptions = NULL, DeliveryOptions = NULL, ReputationOptions = NULL, SendingOptions = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateConfigurationSet",
    http_method = "POST",
    http_path = "/v1/email/configuration-sets",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$create_configuration_set_input(ConfigurationSetName = ConfigurationSetName, TrackingOptions = TrackingOptions, DeliveryOptions = DeliveryOptions, ReputationOptions = ReputationOptions, SendingOptions = SendingOptions, Tags = Tags)
  output <- .pinpointemail$create_configuration_set_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$create_configuration_set <- pinpointemail_create_configuration_set

#' Create an event destination
#'
#' @description
#' Create an event destination. In Amazon Pinpoint, *events* include message sends, deliveries, opens, clicks, bounces, and complaints. *Event destinations* are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_create_configuration_set_event_destination/](https://www.paws-r-sdk.com/docs/pinpointemail_create_configuration_set_event_destination/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to add an event
#' destination to.
#' @param EventDestinationName &#91;required&#93; A name that identifies the event destination within the configuration
#' set.
#' @param EventDestination &#91;required&#93; An object that defines the event destination.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_create_configuration_set_event_destination
pinpointemail_create_configuration_set_event_destination <- function(ConfigurationSetName, EventDestinationName, EventDestination) {
  op <- new_operation(
    name = "CreateConfigurationSetEventDestination",
    http_method = "POST",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$create_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName, EventDestination = EventDestination)
  output <- .pinpointemail$create_configuration_set_event_destination_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$create_configuration_set_event_destination <- pinpointemail_create_configuration_set_event_destination

#' Create a new pool of dedicated IP addresses
#'
#' @description
#' Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are associated with your Amazon Pinpoint account. You can associate a pool with a configuration set. When you send an email that uses that configuration set, Amazon Pinpoint sends it using only the IP addresses in the associated pool.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_create_dedicated_ip_pool/](https://www.paws-r-sdk.com/docs/pinpointemail_create_dedicated_ip_pool/) for full documentation.
#'
#' @param PoolName &#91;required&#93; The name of the dedicated IP pool.
#' @param Tags An object that defines the tags (keys and values) that you want to
#' associate with the pool.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_create_dedicated_ip_pool
pinpointemail_create_dedicated_ip_pool <- function(PoolName, Tags = NULL) {
  op <- new_operation(
    name = "CreateDedicatedIpPool",
    http_method = "POST",
    http_path = "/v1/email/dedicated-ip-pools",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$create_dedicated_ip_pool_input(PoolName = PoolName, Tags = Tags)
  output <- .pinpointemail$create_dedicated_ip_pool_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$create_dedicated_ip_pool <- pinpointemail_create_dedicated_ip_pool

#' Create a new predictive inbox placement test
#'
#' @description
#' Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your messages will be handled by various email providers around the world. When you perform a predictive inbox placement test, you provide a sample message that contains the content that you plan to send to your customers. Amazon Pinpoint then sends that message to special email addresses spread across several major email providers. After about 24 hours, the test is complete, and you can use the [`get_deliverability_test_report`][pinpointemail_get_deliverability_test_report] operation to view the results of the test.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_create_deliverability_test_report/](https://www.paws-r-sdk.com/docs/pinpointemail_create_deliverability_test_report/) for full documentation.
#'
#' @param ReportName A unique name that helps you to identify the predictive inbox placement
#' test when you retrieve the results.
#' @param FromEmailAddress &#91;required&#93; The email address that the predictive inbox placement test email was
#' sent from.
#' @param Content &#91;required&#93; The HTML body of the message that you sent when you performed the
#' predictive inbox placement test.
#' @param Tags An array of objects that define the tags (keys and values) that you want
#' to associate with the predictive inbox placement test.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_create_deliverability_test_report
pinpointemail_create_deliverability_test_report <- function(ReportName = NULL, FromEmailAddress, Content, Tags = NULL) {
  op <- new_operation(
    name = "CreateDeliverabilityTestReport",
    http_method = "POST",
    http_path = "/v1/email/deliverability-dashboard/test",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$create_deliverability_test_report_input(ReportName = ReportName, FromEmailAddress = FromEmailAddress, Content = Content, Tags = Tags)
  output <- .pinpointemail$create_deliverability_test_report_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$create_deliverability_test_report <- pinpointemail_create_deliverability_test_report

#' Verifies an email identity for use with Amazon Pinpoint
#'
#' @description
#' Verifies an email identity for use with Amazon Pinpoint. In Amazon Pinpoint, an identity is an email address or domain that you use when you send email. Before you can use an identity to send email with Amazon Pinpoint, you first have to verify it. By verifying an address, you demonstrate that you're the owner of the address, and that you've given Amazon Pinpoint permission to send email from the address.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_create_email_identity/](https://www.paws-r-sdk.com/docs/pinpointemail_create_email_identity/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The email address or domain that you want to verify.
#' @param Tags An array of objects that define the tags (keys and values) that you want
#' to associate with the email identity.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_create_email_identity
pinpointemail_create_email_identity <- function(EmailIdentity, Tags = NULL) {
  op <- new_operation(
    name = "CreateEmailIdentity",
    http_method = "POST",
    http_path = "/v1/email/identities",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$create_email_identity_input(EmailIdentity = EmailIdentity, Tags = Tags)
  output <- .pinpointemail$create_email_identity_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$create_email_identity <- pinpointemail_create_email_identity

#' Delete an existing configuration set
#'
#' @description
#' Delete an existing configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_delete_configuration_set/](https://www.paws-r-sdk.com/docs/pinpointemail_delete_configuration_set/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to delete.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_delete_configuration_set
pinpointemail_delete_configuration_set <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "DeleteConfigurationSet",
    http_method = "DELETE",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$delete_configuration_set_input(ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointemail$delete_configuration_set_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$delete_configuration_set <- pinpointemail_delete_configuration_set

#' Delete an event destination
#'
#' @description
#' Delete an event destination.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_delete_configuration_set_event_destination/](https://www.paws-r-sdk.com/docs/pinpointemail_delete_configuration_set_event_destination/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that contains the event destination
#' that you want to delete.
#' @param EventDestinationName &#91;required&#93; The name of the event destination that you want to delete.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_delete_configuration_set_event_destination
pinpointemail_delete_configuration_set_event_destination <- function(ConfigurationSetName, EventDestinationName) {
  op <- new_operation(
    name = "DeleteConfigurationSetEventDestination",
    http_method = "DELETE",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$delete_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName)
  output <- .pinpointemail$delete_configuration_set_event_destination_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$delete_configuration_set_event_destination <- pinpointemail_delete_configuration_set_event_destination

#' Delete a dedicated IP pool
#'
#' @description
#' Delete a dedicated IP pool.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_delete_dedicated_ip_pool/](https://www.paws-r-sdk.com/docs/pinpointemail_delete_dedicated_ip_pool/) for full documentation.
#'
#' @param PoolName &#91;required&#93; The name of the dedicated IP pool that you want to delete.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_delete_dedicated_ip_pool
pinpointemail_delete_dedicated_ip_pool <- function(PoolName) {
  op <- new_operation(
    name = "DeleteDedicatedIpPool",
    http_method = "DELETE",
    http_path = "/v1/email/dedicated-ip-pools/{PoolName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$delete_dedicated_ip_pool_input(PoolName = PoolName)
  output <- .pinpointemail$delete_dedicated_ip_pool_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$delete_dedicated_ip_pool <- pinpointemail_delete_dedicated_ip_pool

#' Deletes an email identity that you previously verified for use with
#' Amazon Pinpoint
#'
#' @description
#' Deletes an email identity that you previously verified for use with Amazon Pinpoint. An identity can be either an email address or a domain name.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_delete_email_identity/](https://www.paws-r-sdk.com/docs/pinpointemail_delete_email_identity/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The identity (that is, the email address or domain) that you want to
#' delete from your Amazon Pinpoint account.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_delete_email_identity
pinpointemail_delete_email_identity <- function(EmailIdentity) {
  op <- new_operation(
    name = "DeleteEmailIdentity",
    http_method = "DELETE",
    http_path = "/v1/email/identities/{EmailIdentity}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$delete_email_identity_input(EmailIdentity = EmailIdentity)
  output <- .pinpointemail$delete_email_identity_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$delete_email_identity <- pinpointemail_delete_email_identity

#' Obtain information about the email-sending status and capabilities of
#' your Amazon Pinpoint account in the current AWS Region
#'
#' @description
#' Obtain information about the email-sending status and capabilities of your Amazon Pinpoint account in the current AWS Region.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_get_account/](https://www.paws-r-sdk.com/docs/pinpointemail_get_account/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_account
pinpointemail_get_account <- function() {
  op <- new_operation(
    name = "GetAccount",
    http_method = "GET",
    http_path = "/v1/email/account",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$get_account_input()
  output <- .pinpointemail$get_account_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_account <- pinpointemail_get_account

#' Retrieve a list of the blacklists that your dedicated IP addresses
#' appear on
#'
#' @description
#' Retrieve a list of the blacklists that your dedicated IP addresses appear on.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_get_blacklist_reports/](https://www.paws-r-sdk.com/docs/pinpointemail_get_blacklist_reports/) for full documentation.
#'
#' @param BlacklistItemNames &#91;required&#93; A list of IP addresses that you want to retrieve blacklist information
#' about. You can only specify the dedicated IP addresses that you use to
#' send email using Amazon Pinpoint or Amazon SES.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_blacklist_reports
pinpointemail_get_blacklist_reports <- function(BlacklistItemNames) {
  op <- new_operation(
    name = "GetBlacklistReports",
    http_method = "GET",
    http_path = "/v1/email/deliverability-dashboard/blacklist-report",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$get_blacklist_reports_input(BlacklistItemNames = BlacklistItemNames)
  output <- .pinpointemail$get_blacklist_reports_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_blacklist_reports <- pinpointemail_get_blacklist_reports

#' Get information about an existing configuration set, including the
#' dedicated IP pool that it's associated with, whether or not it's enabled
#' for sending email, and more
#'
#' @description
#' Get information about an existing configuration set, including the dedicated IP pool that it's associated with, whether or not it's enabled for sending email, and more.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_get_configuration_set/](https://www.paws-r-sdk.com/docs/pinpointemail_get_configuration_set/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to obtain more
#' information about.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_configuration_set
pinpointemail_get_configuration_set <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "GetConfigurationSet",
    http_method = "GET",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$get_configuration_set_input(ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointemail$get_configuration_set_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_configuration_set <- pinpointemail_get_configuration_set

#' Retrieve a list of event destinations that are associated with a
#' configuration set
#'
#' @description
#' Retrieve a list of event destinations that are associated with a configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_get_configuration_set_event_destinations/](https://www.paws-r-sdk.com/docs/pinpointemail_get_configuration_set_event_destinations/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that contains the event destination.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_configuration_set_event_destinations
pinpointemail_get_configuration_set_event_destinations <- function(ConfigurationSetName) {
  op <- new_operation(
    name = "GetConfigurationSetEventDestinations",
    http_method = "GET",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$get_configuration_set_event_destinations_input(ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointemail$get_configuration_set_event_destinations_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_configuration_set_event_destinations <- pinpointemail_get_configuration_set_event_destinations

#' Get information about a dedicated IP address, including the name of the
#' dedicated IP pool that it's associated with, as well information about
#' the automatic warm-up process for the address
#'
#' @description
#' Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated with, as well information about the automatic warm-up process for the address.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_get_dedicated_ip/](https://www.paws-r-sdk.com/docs/pinpointemail_get_dedicated_ip/) for full documentation.
#'
#' @param Ip &#91;required&#93; The IP address that you want to obtain more information about. The value
#' you specify has to be a dedicated IP address that's assocaited with your
#' Amazon Pinpoint account.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_dedicated_ip
pinpointemail_get_dedicated_ip <- function(Ip) {
  op <- new_operation(
    name = "GetDedicatedIp",
    http_method = "GET",
    http_path = "/v1/email/dedicated-ips/{IP}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$get_dedicated_ip_input(Ip = Ip)
  output <- .pinpointemail$get_dedicated_ip_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_dedicated_ip <- pinpointemail_get_dedicated_ip

#' List the dedicated IP addresses that are associated with your Amazon
#' Pinpoint account
#'
#' @description
#' List the dedicated IP addresses that are associated with your Amazon Pinpoint account.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_get_dedicated_ips/](https://www.paws-r-sdk.com/docs/pinpointemail_get_dedicated_ips/) for full documentation.
#'
#' @param PoolName The name of the IP pool that the dedicated IP address is associated
#' with.
#' @param NextToken A token returned from a previous call to
#' [`get_dedicated_ips`][pinpointemail_get_dedicated_ips] to indicate the
#' position of the dedicated IP pool in the list of IP pools.
#' @param PageSize The number of results to show in a single call to
#' `GetDedicatedIpsRequest`. If the number of results is larger than the
#' number you specified in this parameter, then the response includes a
#' `NextToken` element, which you can use to obtain additional results.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_dedicated_ips
pinpointemail_get_dedicated_ips <- function(PoolName = NULL, NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "GetDedicatedIps",
    http_method = "GET",
    http_path = "/v1/email/dedicated-ips",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "PageSize", output_token = "NextToken", result_key = "DedicatedIps"),
    stream_api = FALSE
  )
  input <- .pinpointemail$get_dedicated_ips_input(PoolName = PoolName, NextToken = NextToken, PageSize = PageSize)
  output <- .pinpointemail$get_dedicated_ips_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_dedicated_ips <- pinpointemail_get_dedicated_ips

#' Retrieve information about the status of the Deliverability dashboard
#' for your Amazon Pinpoint account
#'
#' @description
#' Retrieve information about the status of the Deliverability dashboard for your Amazon Pinpoint account. When the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email using Amazon Pinpoint. You also gain the ability to perform predictive inbox placement tests.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_get_deliverability_dashboard_options/](https://www.paws-r-sdk.com/docs/pinpointemail_get_deliverability_dashboard_options/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_deliverability_dashboard_options
pinpointemail_get_deliverability_dashboard_options <- function() {
  op <- new_operation(
    name = "GetDeliverabilityDashboardOptions",
    http_method = "GET",
    http_path = "/v1/email/deliverability-dashboard",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$get_deliverability_dashboard_options_input()
  output <- .pinpointemail$get_deliverability_dashboard_options_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_deliverability_dashboard_options <- pinpointemail_get_deliverability_dashboard_options

#' Retrieve the results of a predictive inbox placement test
#'
#' @description
#' Retrieve the results of a predictive inbox placement test.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_get_deliverability_test_report/](https://www.paws-r-sdk.com/docs/pinpointemail_get_deliverability_test_report/) for full documentation.
#'
#' @param ReportId &#91;required&#93; A unique string that identifies the predictive inbox placement test.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_deliverability_test_report
pinpointemail_get_deliverability_test_report <- function(ReportId) {
  op <- new_operation(
    name = "GetDeliverabilityTestReport",
    http_method = "GET",
    http_path = "/v1/email/deliverability-dashboard/test-reports/{ReportId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$get_deliverability_test_report_input(ReportId = ReportId)
  output <- .pinpointemail$get_deliverability_test_report_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_deliverability_test_report <- pinpointemail_get_deliverability_test_report

#' Retrieve all the deliverability data for a specific campaign
#'
#' @description
#' Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled for ([`put_deliverability_dashboard_option`][pinpointemail_put_deliverability_dashboard_option] operation).
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_get_domain_deliverability_campaign/](https://www.paws-r-sdk.com/docs/pinpointemail_get_domain_deliverability_campaign/) for full documentation.
#'
#' @param CampaignId &#91;required&#93; The unique identifier for the campaign. Amazon Pinpoint automatically
#' generates and assigns this identifier to a campaign. This value is not
#' the same as the campaign identifier that Amazon Pinpoint assigns to
#' campaigns that you create and manage by using the Amazon Pinpoint API or
#' the Amazon Pinpoint console.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_domain_deliverability_campaign
pinpointemail_get_domain_deliverability_campaign <- function(CampaignId) {
  op <- new_operation(
    name = "GetDomainDeliverabilityCampaign",
    http_method = "GET",
    http_path = "/v1/email/deliverability-dashboard/campaigns/{CampaignId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$get_domain_deliverability_campaign_input(CampaignId = CampaignId)
  output <- .pinpointemail$get_domain_deliverability_campaign_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_domain_deliverability_campaign <- pinpointemail_get_domain_deliverability_campaign

#' Retrieve inbox placement and engagement rates for the domains that you
#' use to send email
#'
#' @description
#' Retrieve inbox placement and engagement rates for the domains that you use to send email.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_get_domain_statistics_report/](https://www.paws-r-sdk.com/docs/pinpointemail_get_domain_statistics_report/) for full documentation.
#'
#' @param Domain &#91;required&#93; The domain that you want to obtain deliverability metrics for.
#' @param StartDate &#91;required&#93; The first day (in Unix time) that you want to obtain domain
#' deliverability metrics for.
#' @param EndDate &#91;required&#93; The last day (in Unix time) that you want to obtain domain
#' deliverability metrics for. The `EndDate` that you specify has to be
#' less than or equal to 30 days after the `StartDate`.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_domain_statistics_report
pinpointemail_get_domain_statistics_report <- function(Domain, StartDate, EndDate) {
  op <- new_operation(
    name = "GetDomainStatisticsReport",
    http_method = "GET",
    http_path = "/v1/email/deliverability-dashboard/statistics-report/{Domain}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$get_domain_statistics_report_input(Domain = Domain, StartDate = StartDate, EndDate = EndDate)
  output <- .pinpointemail$get_domain_statistics_report_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_domain_statistics_report <- pinpointemail_get_domain_statistics_report

#' Provides information about a specific identity associated with your
#' Amazon Pinpoint account, including the identity's verification status,
#' its DKIM authentication status, and its custom Mail-From settings
#'
#' @description
#' Provides information about a specific identity associated with your Amazon Pinpoint account, including the identity's verification status, its DKIM authentication status, and its custom Mail-From settings.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_get_email_identity/](https://www.paws-r-sdk.com/docs/pinpointemail_get_email_identity/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The email identity that you want to retrieve details for.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_get_email_identity
pinpointemail_get_email_identity <- function(EmailIdentity) {
  op <- new_operation(
    name = "GetEmailIdentity",
    http_method = "GET",
    http_path = "/v1/email/identities/{EmailIdentity}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$get_email_identity_input(EmailIdentity = EmailIdentity)
  output <- .pinpointemail$get_email_identity_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$get_email_identity <- pinpointemail_get_email_identity

#' List all of the configuration sets associated with your Amazon Pinpoint
#' account in the current region
#'
#' @description
#' List all of the configuration sets associated with your Amazon Pinpoint account in the current region.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_list_configuration_sets/](https://www.paws-r-sdk.com/docs/pinpointemail_list_configuration_sets/) for full documentation.
#'
#' @param NextToken A token returned from a previous call to
#' [`list_configuration_sets`][pinpointemail_list_configuration_sets] to
#' indicate the position in the list of configuration sets.
#' @param PageSize The number of results to show in a single call to
#' [`list_configuration_sets`][pinpointemail_list_configuration_sets]. If
#' the number of results is larger than the number you specified in this
#' parameter, then the response includes a `NextToken` element, which you
#' can use to obtain additional results.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_list_configuration_sets
pinpointemail_list_configuration_sets <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListConfigurationSets",
    http_method = "GET",
    http_path = "/v1/email/configuration-sets",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "PageSize", output_token = "NextToken", result_key = "ConfigurationSets"),
    stream_api = FALSE
  )
  input <- .pinpointemail$list_configuration_sets_input(NextToken = NextToken, PageSize = PageSize)
  output <- .pinpointemail$list_configuration_sets_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$list_configuration_sets <- pinpointemail_list_configuration_sets

#' List all of the dedicated IP pools that exist in your Amazon Pinpoint
#' account in the current AWS Region
#'
#' @description
#' List all of the dedicated IP pools that exist in your Amazon Pinpoint account in the current AWS Region.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_list_dedicated_ip_pools/](https://www.paws-r-sdk.com/docs/pinpointemail_list_dedicated_ip_pools/) for full documentation.
#'
#' @param NextToken A token returned from a previous call to
#' [`list_dedicated_ip_pools`][pinpointemail_list_dedicated_ip_pools] to
#' indicate the position in the list of dedicated IP pools.
#' @param PageSize The number of results to show in a single call to
#' [`list_dedicated_ip_pools`][pinpointemail_list_dedicated_ip_pools]. If
#' the number of results is larger than the number you specified in this
#' parameter, then the response includes a `NextToken` element, which you
#' can use to obtain additional results.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_list_dedicated_ip_pools
pinpointemail_list_dedicated_ip_pools <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListDedicatedIpPools",
    http_method = "GET",
    http_path = "/v1/email/dedicated-ip-pools",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "PageSize", output_token = "NextToken", result_key = "DedicatedIpPools"),
    stream_api = FALSE
  )
  input <- .pinpointemail$list_dedicated_ip_pools_input(NextToken = NextToken, PageSize = PageSize)
  output <- .pinpointemail$list_dedicated_ip_pools_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$list_dedicated_ip_pools <- pinpointemail_list_dedicated_ip_pools

#' Show a list of the predictive inbox placement tests that you've
#' performed, regardless of their statuses
#'
#' @description
#' Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For predictive inbox placement tests that are complete, you can use the [`get_deliverability_test_report`][pinpointemail_get_deliverability_test_report] operation to view the results.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_list_deliverability_test_reports/](https://www.paws-r-sdk.com/docs/pinpointemail_list_deliverability_test_reports/) for full documentation.
#'
#' @param NextToken A token returned from a previous call to
#' [`list_deliverability_test_reports`][pinpointemail_list_deliverability_test_reports]
#' to indicate the position in the list of predictive inbox placement
#' tests.
#' @param PageSize The number of results to show in a single call to
#' [`list_deliverability_test_reports`][pinpointemail_list_deliverability_test_reports].
#' If the number of results is larger than the number you specified in this
#' parameter, then the response includes a `NextToken` element, which you
#' can use to obtain additional results.
#' 
#' The value you specify has to be at least 0, and can be no more than
#' 1000.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_list_deliverability_test_reports
pinpointemail_list_deliverability_test_reports <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListDeliverabilityTestReports",
    http_method = "GET",
    http_path = "/v1/email/deliverability-dashboard/test-reports",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "PageSize", output_token = "NextToken", result_key = "DeliverabilityTestReports"),
    stream_api = FALSE
  )
  input <- .pinpointemail$list_deliverability_test_reports_input(NextToken = NextToken, PageSize = PageSize)
  output <- .pinpointemail$list_deliverability_test_reports_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$list_deliverability_test_reports <- pinpointemail_list_deliverability_test_reports

#' Retrieve deliverability data for all the campaigns that used a specific
#' domain to send email during a specified time range
#'
#' @description
#' Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified time range. This data is available for a domain only if you enabled the Deliverability dashboard ([`put_deliverability_dashboard_option`][pinpointemail_put_deliverability_dashboard_option] operation) for the domain.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_list_domain_deliverability_campaigns/](https://www.paws-r-sdk.com/docs/pinpointemail_list_domain_deliverability_campaigns/) for full documentation.
#'
#' @param StartDate &#91;required&#93; The first day, in Unix time format, that you want to obtain
#' deliverability data for.
#' @param EndDate &#91;required&#93; The last day, in Unix time format, that you want to obtain
#' deliverability data for. This value has to be less than or equal to 30
#' days after the value of the `StartDate` parameter.
#' @param SubscribedDomain &#91;required&#93; The domain to obtain deliverability data for.
#' @param NextToken A token that’s returned from a previous call to the
#' [`list_domain_deliverability_campaigns`][pinpointemail_list_domain_deliverability_campaigns]
#' operation. This token indicates the position of a campaign in the list
#' of campaigns.
#' @param PageSize The maximum number of results to include in response to a single call to
#' the
#' [`list_domain_deliverability_campaigns`][pinpointemail_list_domain_deliverability_campaigns]
#' operation. If the number of results is larger than the number that you
#' specify in this parameter, the response includes a `NextToken` element,
#' which you can use to obtain additional results.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_list_domain_deliverability_campaigns
pinpointemail_list_domain_deliverability_campaigns <- function(StartDate, EndDate, SubscribedDomain, NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListDomainDeliverabilityCampaigns",
    http_method = "GET",
    http_path = "/v1/email/deliverability-dashboard/domains/{SubscribedDomain}/campaigns",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "PageSize"),
    stream_api = FALSE
  )
  input <- .pinpointemail$list_domain_deliverability_campaigns_input(StartDate = StartDate, EndDate = EndDate, SubscribedDomain = SubscribedDomain, NextToken = NextToken, PageSize = PageSize)
  output <- .pinpointemail$list_domain_deliverability_campaigns_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$list_domain_deliverability_campaigns <- pinpointemail_list_domain_deliverability_campaigns

#' Returns a list of all of the email identities that are associated with
#' your Amazon Pinpoint account
#'
#' @description
#' Returns a list of all of the email identities that are associated with your Amazon Pinpoint account. An identity can be either an email address or a domain. This operation returns identities that are verified as well as those that aren't.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_list_email_identities/](https://www.paws-r-sdk.com/docs/pinpointemail_list_email_identities/) for full documentation.
#'
#' @param NextToken A token returned from a previous call to
#' [`list_email_identities`][pinpointemail_list_email_identities] to
#' indicate the position in the list of identities.
#' @param PageSize The number of results to show in a single call to
#' [`list_email_identities`][pinpointemail_list_email_identities]. If the
#' number of results is larger than the number you specified in this
#' parameter, then the response includes a `NextToken` element, which you
#' can use to obtain additional results.
#' 
#' The value you specify has to be at least 0, and can be no more than
#' 1000.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_list_email_identities
pinpointemail_list_email_identities <- function(NextToken = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "ListEmailIdentities",
    http_method = "GET",
    http_path = "/v1/email/identities",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "PageSize", output_token = "NextToken", result_key = "EmailIdentities"),
    stream_api = FALSE
  )
  input <- .pinpointemail$list_email_identities_input(NextToken = NextToken, PageSize = PageSize)
  output <- .pinpointemail$list_email_identities_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$list_email_identities <- pinpointemail_list_email_identities

#' Retrieve a list of the tags (keys and values) that are associated with a
#' specified resource
#'
#' @description
#' Retrieve a list of the tags (keys and values) that are associated with a specified resource. A *tag* is a label that you optionally define and associate with a resource in Amazon Pinpoint. Each tag consists of a required *tag key* and an optional associated *tag value*. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/pinpointemail_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to retrieve
#' tag information for.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_list_tags_for_resource
pinpointemail_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/v1/email/tags",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .pinpointemail$list_tags_for_resource_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$list_tags_for_resource <- pinpointemail_list_tags_for_resource

#' Enable or disable the automatic warm-up feature for dedicated IP
#' addresses
#'
#' @description
#' Enable or disable the automatic warm-up feature for dedicated IP addresses.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_put_account_dedicated_ip_warmup_attributes/](https://www.paws-r-sdk.com/docs/pinpointemail_put_account_dedicated_ip_warmup_attributes/) for full documentation.
#'
#' @param AutoWarmupEnabled Enables or disables the automatic warm-up feature for dedicated IP
#' addresses that are associated with your Amazon Pinpoint account in the
#' current AWS Region. Set to `true` to enable the automatic warm-up
#' feature, or set to `false` to disable it.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_account_dedicated_ip_warmup_attributes
pinpointemail_put_account_dedicated_ip_warmup_attributes <- function(AutoWarmupEnabled = NULL) {
  op <- new_operation(
    name = "PutAccountDedicatedIpWarmupAttributes",
    http_method = "PUT",
    http_path = "/v1/email/account/dedicated-ips/warmup",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$put_account_dedicated_ip_warmup_attributes_input(AutoWarmupEnabled = AutoWarmupEnabled)
  output <- .pinpointemail$put_account_dedicated_ip_warmup_attributes_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_account_dedicated_ip_warmup_attributes <- pinpointemail_put_account_dedicated_ip_warmup_attributes

#' Enable or disable the ability of your account to send email
#'
#' @description
#' Enable or disable the ability of your account to send email.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_put_account_sending_attributes/](https://www.paws-r-sdk.com/docs/pinpointemail_put_account_sending_attributes/) for full documentation.
#'
#' @param SendingEnabled Enables or disables your account's ability to send email. Set to `true`
#' to enable email sending, or set to `false` to disable email sending.
#' 
#' If AWS paused your account's ability to send email, you can't use this
#' operation to resume your account's ability to send email.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_account_sending_attributes
pinpointemail_put_account_sending_attributes <- function(SendingEnabled = NULL) {
  op <- new_operation(
    name = "PutAccountSendingAttributes",
    http_method = "PUT",
    http_path = "/v1/email/account/sending",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$put_account_sending_attributes_input(SendingEnabled = SendingEnabled)
  output <- .pinpointemail$put_account_sending_attributes_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_account_sending_attributes <- pinpointemail_put_account_sending_attributes

#' Associate a configuration set with a dedicated IP pool
#'
#' @description
#' Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of dedicated IP addresses for sending specific types of email.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_put_configuration_set_delivery_options/](https://www.paws-r-sdk.com/docs/pinpointemail_put_configuration_set_delivery_options/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to associate with a
#' dedicated IP pool.
#' @param TlsPolicy Specifies whether messages that use the configuration set are required
#' to use Transport Layer Security (TLS). If the value is `Require`,
#' messages are only delivered if a TLS connection can be established. If
#' the value is `Optional`, messages can be delivered in plain text if a
#' TLS connection can't be established.
#' @param SendingPoolName The name of the dedicated IP pool that you want to associate with the
#' configuration set.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_configuration_set_delivery_options
pinpointemail_put_configuration_set_delivery_options <- function(ConfigurationSetName, TlsPolicy = NULL, SendingPoolName = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetDeliveryOptions",
    http_method = "PUT",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/delivery-options",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$put_configuration_set_delivery_options_input(ConfigurationSetName = ConfigurationSetName, TlsPolicy = TlsPolicy, SendingPoolName = SendingPoolName)
  output <- .pinpointemail$put_configuration_set_delivery_options_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_configuration_set_delivery_options <- pinpointemail_put_configuration_set_delivery_options

#' Enable or disable collection of reputation metrics for emails that you
#' send using a particular configuration set in a specific AWS Region
#'
#' @description
#' Enable or disable collection of reputation metrics for emails that you send using a particular configuration set in a specific AWS Region.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_put_configuration_set_reputation_options/](https://www.paws-r-sdk.com/docs/pinpointemail_put_configuration_set_reputation_options/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to enable or disable
#' reputation metric tracking for.
#' @param ReputationMetricsEnabled If `true`, tracking of reputation metrics is enabled for the
#' configuration set. If `false`, tracking of reputation metrics is
#' disabled for the configuration set.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_configuration_set_reputation_options
pinpointemail_put_configuration_set_reputation_options <- function(ConfigurationSetName, ReputationMetricsEnabled = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetReputationOptions",
    http_method = "PUT",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/reputation-options",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$put_configuration_set_reputation_options_input(ConfigurationSetName = ConfigurationSetName, ReputationMetricsEnabled = ReputationMetricsEnabled)
  output <- .pinpointemail$put_configuration_set_reputation_options_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_configuration_set_reputation_options <- pinpointemail_put_configuration_set_reputation_options

#' Enable or disable email sending for messages that use a particular
#' configuration set in a specific AWS Region
#'
#' @description
#' Enable or disable email sending for messages that use a particular configuration set in a specific AWS Region.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_put_configuration_set_sending_options/](https://www.paws-r-sdk.com/docs/pinpointemail_put_configuration_set_sending_options/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to enable or disable
#' email sending for.
#' @param SendingEnabled If `true`, email sending is enabled for the configuration set. If
#' `false`, email sending is disabled for the configuration set.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_configuration_set_sending_options
pinpointemail_put_configuration_set_sending_options <- function(ConfigurationSetName, SendingEnabled = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetSendingOptions",
    http_method = "PUT",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/sending",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$put_configuration_set_sending_options_input(ConfigurationSetName = ConfigurationSetName, SendingEnabled = SendingEnabled)
  output <- .pinpointemail$put_configuration_set_sending_options_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_configuration_set_sending_options <- pinpointemail_put_configuration_set_sending_options

#' Specify a custom domain to use for open and click tracking elements in
#' email that you send using Amazon Pinpoint
#'
#' @description
#' Specify a custom domain to use for open and click tracking elements in email that you send using Amazon Pinpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_put_configuration_set_tracking_options/](https://www.paws-r-sdk.com/docs/pinpointemail_put_configuration_set_tracking_options/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that you want to add a custom tracking
#' domain to.
#' @param CustomRedirectDomain The domain that you want to use to track open and click events.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_configuration_set_tracking_options
pinpointemail_put_configuration_set_tracking_options <- function(ConfigurationSetName, CustomRedirectDomain = NULL) {
  op <- new_operation(
    name = "PutConfigurationSetTrackingOptions",
    http_method = "PUT",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/tracking-options",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$put_configuration_set_tracking_options_input(ConfigurationSetName = ConfigurationSetName, CustomRedirectDomain = CustomRedirectDomain)
  output <- .pinpointemail$put_configuration_set_tracking_options_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_configuration_set_tracking_options <- pinpointemail_put_configuration_set_tracking_options

#' Move a dedicated IP address to an existing dedicated IP pool
#'
#' @description
#' Move a dedicated IP address to an existing dedicated IP pool.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_put_dedicated_ip_in_pool/](https://www.paws-r-sdk.com/docs/pinpointemail_put_dedicated_ip_in_pool/) for full documentation.
#'
#' @param Ip &#91;required&#93; The IP address that you want to move to the dedicated IP pool. The value
#' you specify has to be a dedicated IP address that's associated with your
#' Amazon Pinpoint account.
#' @param DestinationPoolName &#91;required&#93; The name of the IP pool that you want to add the dedicated IP address
#' to. You have to specify an IP pool that already exists.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_dedicated_ip_in_pool
pinpointemail_put_dedicated_ip_in_pool <- function(Ip, DestinationPoolName) {
  op <- new_operation(
    name = "PutDedicatedIpInPool",
    http_method = "PUT",
    http_path = "/v1/email/dedicated-ips/{IP}/pool",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$put_dedicated_ip_in_pool_input(Ip = Ip, DestinationPoolName = DestinationPoolName)
  output <- .pinpointemail$put_dedicated_ip_in_pool_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_dedicated_ip_in_pool <- pinpointemail_put_dedicated_ip_in_pool

#' Put dedicated ip warmup attributes
#'
#' @description
#' Put dedicated ip warmup attributes
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_put_dedicated_ip_warmup_attributes/](https://www.paws-r-sdk.com/docs/pinpointemail_put_dedicated_ip_warmup_attributes/) for full documentation.
#'
#' @param Ip &#91;required&#93; The dedicated IP address that you want to update the warm-up attributes
#' for.
#' @param WarmupPercentage &#91;required&#93; The warm-up percentage that you want to associate with the dedicated IP
#' address.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_dedicated_ip_warmup_attributes
pinpointemail_put_dedicated_ip_warmup_attributes <- function(Ip, WarmupPercentage) {
  op <- new_operation(
    name = "PutDedicatedIpWarmupAttributes",
    http_method = "PUT",
    http_path = "/v1/email/dedicated-ips/{IP}/warmup",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$put_dedicated_ip_warmup_attributes_input(Ip = Ip, WarmupPercentage = WarmupPercentage)
  output <- .pinpointemail$put_dedicated_ip_warmup_attributes_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_dedicated_ip_warmup_attributes <- pinpointemail_put_dedicated_ip_warmup_attributes

#' Enable or disable the Deliverability dashboard for your Amazon Pinpoint
#' account
#'
#' @description
#' Enable or disable the Deliverability dashboard for your Amazon Pinpoint account. When you enable the Deliverability dashboard, you gain access to reputation, deliverability, and other metrics for the domains that you use to send email using Amazon Pinpoint. You also gain the ability to perform predictive inbox placement tests.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_put_deliverability_dashboard_option/](https://www.paws-r-sdk.com/docs/pinpointemail_put_deliverability_dashboard_option/) for full documentation.
#'
#' @param DashboardEnabled &#91;required&#93; Specifies whether to enable the Deliverability dashboard for your Amazon
#' Pinpoint account. To enable the dashboard, set this value to `true`.
#' @param SubscribedDomains An array of objects, one for each verified domain that you use to send
#' email and enabled the Deliverability dashboard for.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_deliverability_dashboard_option
pinpointemail_put_deliverability_dashboard_option <- function(DashboardEnabled, SubscribedDomains = NULL) {
  op <- new_operation(
    name = "PutDeliverabilityDashboardOption",
    http_method = "PUT",
    http_path = "/v1/email/deliverability-dashboard",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$put_deliverability_dashboard_option_input(DashboardEnabled = DashboardEnabled, SubscribedDomains = SubscribedDomains)
  output <- .pinpointemail$put_deliverability_dashboard_option_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_deliverability_dashboard_option <- pinpointemail_put_deliverability_dashboard_option

#' Used to enable or disable DKIM authentication for an email identity
#'
#' @description
#' Used to enable or disable DKIM authentication for an email identity.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_put_email_identity_dkim_attributes/](https://www.paws-r-sdk.com/docs/pinpointemail_put_email_identity_dkim_attributes/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The email identity that you want to change the DKIM settings for.
#' @param SigningEnabled Sets the DKIM signing configuration for the identity.
#' 
#' When you set this value `true`, then the messages that Amazon Pinpoint
#' sends from the identity are DKIM-signed. When you set this value to
#' `false`, then the messages that Amazon Pinpoint sends from the identity
#' aren't DKIM-signed.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_email_identity_dkim_attributes
pinpointemail_put_email_identity_dkim_attributes <- function(EmailIdentity, SigningEnabled = NULL) {
  op <- new_operation(
    name = "PutEmailIdentityDkimAttributes",
    http_method = "PUT",
    http_path = "/v1/email/identities/{EmailIdentity}/dkim",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$put_email_identity_dkim_attributes_input(EmailIdentity = EmailIdentity, SigningEnabled = SigningEnabled)
  output <- .pinpointemail$put_email_identity_dkim_attributes_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_email_identity_dkim_attributes <- pinpointemail_put_email_identity_dkim_attributes

#' Used to enable or disable feedback forwarding for an identity
#'
#' @description
#' Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_put_email_identity_feedback_attributes/](https://www.paws-r-sdk.com/docs/pinpointemail_put_email_identity_feedback_attributes/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The email identity that you want to configure bounce and complaint
#' feedback forwarding for.
#' @param EmailForwardingEnabled Sets the feedback forwarding configuration for the identity.
#' 
#' If the value is `true`, Amazon Pinpoint sends you email notifications
#' when bounce or complaint events occur. Amazon Pinpoint sends this
#' notification to the address that you specified in the Return-Path header
#' of the original email.
#' 
#' When you set this value to `false`, Amazon Pinpoint sends notifications
#' through other mechanisms, such as by notifying an Amazon SNS topic or
#' another event destination. You're required to have a method of tracking
#' bounces and complaints. If you haven't set up another mechanism for
#' receiving bounce or complaint notifications, Amazon Pinpoint sends an
#' email notification when these events occur (even if this setting is
#' disabled).
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_email_identity_feedback_attributes
pinpointemail_put_email_identity_feedback_attributes <- function(EmailIdentity, EmailForwardingEnabled = NULL) {
  op <- new_operation(
    name = "PutEmailIdentityFeedbackAttributes",
    http_method = "PUT",
    http_path = "/v1/email/identities/{EmailIdentity}/feedback",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$put_email_identity_feedback_attributes_input(EmailIdentity = EmailIdentity, EmailForwardingEnabled = EmailForwardingEnabled)
  output <- .pinpointemail$put_email_identity_feedback_attributes_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_email_identity_feedback_attributes <- pinpointemail_put_email_identity_feedback_attributes

#' Used to enable or disable the custom Mail-From domain configuration for
#' an email identity
#'
#' @description
#' Used to enable or disable the custom Mail-From domain configuration for an email identity.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_put_email_identity_mail_from_attributes/](https://www.paws-r-sdk.com/docs/pinpointemail_put_email_identity_mail_from_attributes/) for full documentation.
#'
#' @param EmailIdentity &#91;required&#93; The verified email identity that you want to set up the custom MAIL FROM
#' domain for.
#' @param MailFromDomain The custom MAIL FROM domain that you want the verified identity to use.
#' The MAIL FROM domain must meet the following criteria:
#' 
#' -   It has to be a subdomain of the verified identity.
#' 
#' -   It can't be used to receive email.
#' 
#' -   It can't be used in a "From" address if the MAIL FROM domain is a
#'     destination for feedback forwarding emails.
#' @param BehaviorOnMxFailure The action that you want Amazon Pinpoint to take if it can't read the
#' required MX record when you send an email. When you set this value to
#' `UseDefaultValue`, Amazon Pinpoint uses *amazonses.com* as the MAIL FROM
#' domain. When you set this value to `RejectMessage`, Amazon Pinpoint
#' returns a `MailFromDomainNotVerified` error, and doesn't attempt to
#' deliver the email.
#' 
#' These behaviors are taken when the custom MAIL FROM domain configuration
#' is in the `Pending`, `Failed`, and `TemporaryFailure` states.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_put_email_identity_mail_from_attributes
pinpointemail_put_email_identity_mail_from_attributes <- function(EmailIdentity, MailFromDomain = NULL, BehaviorOnMxFailure = NULL) {
  op <- new_operation(
    name = "PutEmailIdentityMailFromAttributes",
    http_method = "PUT",
    http_path = "/v1/email/identities/{EmailIdentity}/mail-from",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$put_email_identity_mail_from_attributes_input(EmailIdentity = EmailIdentity, MailFromDomain = MailFromDomain, BehaviorOnMxFailure = BehaviorOnMxFailure)
  output <- .pinpointemail$put_email_identity_mail_from_attributes_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$put_email_identity_mail_from_attributes <- pinpointemail_put_email_identity_mail_from_attributes

#' Sends an email message
#'
#' @description
#' Sends an email message. You can use the Amazon Pinpoint Email API to send two types of messages:
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_send_email/](https://www.paws-r-sdk.com/docs/pinpointemail_send_email/) for full documentation.
#'
#' @param FromEmailAddress The email address that you want to use as the "From" address for the
#' email. The address that you specify has to be verified.
#' @param Destination &#91;required&#93; An object that contains the recipients of the email message.
#' @param ReplyToAddresses The "Reply-to" email addresses for the message. When the recipient
#' replies to the message, each Reply-to address receives the reply.
#' @param FeedbackForwardingEmailAddress The address that Amazon Pinpoint should send bounce and complaint
#' notifications to.
#' @param Content &#91;required&#93; An object that contains the body of the message. You can send either a
#' Simple message or a Raw message.
#' @param EmailTags A list of tags, in the form of name/value pairs, to apply to an email
#' that you send using the [`send_email`][pinpointemail_send_email]
#' operation. Tags correspond to characteristics of the email that you
#' define, so that you can publish email sending events.
#' @param ConfigurationSetName The name of the configuration set that you want to use when sending the
#' email.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_send_email
pinpointemail_send_email <- function(FromEmailAddress = NULL, Destination, ReplyToAddresses = NULL, FeedbackForwardingEmailAddress = NULL, Content, EmailTags = NULL, ConfigurationSetName = NULL) {
  op <- new_operation(
    name = "SendEmail",
    http_method = "POST",
    http_path = "/v1/email/outbound-emails",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$send_email_input(FromEmailAddress = FromEmailAddress, Destination = Destination, ReplyToAddresses = ReplyToAddresses, FeedbackForwardingEmailAddress = FeedbackForwardingEmailAddress, Content = Content, EmailTags = EmailTags, ConfigurationSetName = ConfigurationSetName)
  output <- .pinpointemail$send_email_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$send_email <- pinpointemail_send_email

#' Add one or more tags (keys and values) to a specified resource
#'
#' @description
#' Add one or more tags (keys and values) to a specified resource. A *tag* is a label that you optionally define and associate with a resource in Amazon Pinpoint. Tags can help you categorize and manage resources in different ways, such as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_tag_resource/](https://www.paws-r-sdk.com/docs/pinpointemail_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to add one
#' or more tags to.
#' @param Tags &#91;required&#93; A list of the tags that you want to add to the resource. A tag consists
#' of a required tag key (`Key`) and an associated tag value (`Value`). The
#' maximum length of a tag key is 128 characters. The maximum length of a
#' tag value is 256 characters.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_tag_resource
pinpointemail_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/v1/email/tags",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .pinpointemail$tag_resource_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$tag_resource <- pinpointemail_tag_resource

#' Remove one or more tags (keys and values) from a specified resource
#'
#' @description
#' Remove one or more tags (keys and values) from a specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_untag_resource/](https://www.paws-r-sdk.com/docs/pinpointemail_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to remove
#' one or more tags from.
#' @param TagKeys &#91;required&#93; The tags (tag keys) that you want to remove from the resource. When you
#' specify a tag key, the action removes both that key and its associated
#' tag value.
#' 
#' To remove more than one tag from the resource, append the `TagKeys`
#' parameter and argument for each additional tag to remove, separated by
#' an ampersand. For example:
#' `/v1/email/tags?ResourceArn=ResourceArn&TagKeys=Key1&TagKeys=Key2`
#'
#' @keywords internal
#'
#' @rdname pinpointemail_untag_resource
pinpointemail_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/v1/email/tags",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .pinpointemail$untag_resource_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$untag_resource <- pinpointemail_untag_resource

#' Update the configuration of an event destination for a configuration set
#'
#' @description
#' Update the configuration of an event destination for a configuration set.
#'
#' See [https://www.paws-r-sdk.com/docs/pinpointemail_update_configuration_set_event_destination/](https://www.paws-r-sdk.com/docs/pinpointemail_update_configuration_set_event_destination/) for full documentation.
#'
#' @param ConfigurationSetName &#91;required&#93; The name of the configuration set that contains the event destination
#' that you want to modify.
#' @param EventDestinationName &#91;required&#93; The name of the event destination that you want to modify.
#' @param EventDestination &#91;required&#93; An object that defines the event destination.
#'
#' @keywords internal
#'
#' @rdname pinpointemail_update_configuration_set_event_destination
pinpointemail_update_configuration_set_event_destination <- function(ConfigurationSetName, EventDestinationName, EventDestination) {
  op <- new_operation(
    name = "UpdateConfigurationSetEventDestination",
    http_method = "PUT",
    http_path = "/v1/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .pinpointemail$update_configuration_set_event_destination_input(ConfigurationSetName = ConfigurationSetName, EventDestinationName = EventDestinationName, EventDestination = EventDestination)
  output <- .pinpointemail$update_configuration_set_event_destination_output()
  config <- get_config()
  svc <- .pinpointemail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpointemail$operations$update_configuration_set_event_destination <- pinpointemail_update_configuration_set_event_destination
