% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_queue}
\alias{connect_create_queue}
\title{Creates a new queue for the specified Amazon Connect instance}
\usage{
connect_create_queue(
  InstanceId,
  Name,
  Description = NULL,
  OutboundCallerConfig = NULL,
  OutboundEmailConfig = NULL,
  HoursOfOperationId,
  MaxContacts = NULL,
  QuickConnectIds = NULL,
  Tags = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{Name}{[required] The name of the queue.}

\item{Description}{The description of the queue.}

\item{OutboundCallerConfig}{The outbound caller ID name, number, and outbound whisper flow.}

\item{OutboundEmailConfig}{The outbound email address ID for a specified queue.}

\item{HoursOfOperationId}{[required] The identifier for the hours of operation.}

\item{MaxContacts}{The maximum number of contacts that can be in the queue before it is
considered full.}

\item{QuickConnectIds}{The quick connects available to agents who are working the queue.}

\item{Tags}{The tags used to organize, track, or control access for this resource.
For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.}
}
\description{
Creates a new queue for the specified Amazon Connect instance.

See \url{https://www.paws-r-sdk.com/docs/connect_create_queue/} for full documentation.
}
\keyword{internal}
