% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_rule}
\alias{connect_create_rule}
\title{Creates a rule for the specified Amazon Connect instance}
\usage{
connect_create_rule(
  InstanceId,
  Name,
  TriggerEventSource,
  Function,
  Actions,
  PublishStatus,
  ClientToken = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{Name}{[required] A unique name for the rule.}

\item{TriggerEventSource}{[required] The event source to trigger the rule.}

\item{Function}{[required] The conditions of the rule.}

\item{Actions}{[required] A list of actions to be run when the rule is triggered.}

\item{PublishStatus}{[required] The publish status of the rule.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}
}
\description{
Creates a rule for the specified Amazon Connect instance.

See \url{https://www.paws-r-sdk.com/docs/connect_create_rule/} for full documentation.
}
\keyword{internal}
