% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_search_contact_flow_modules}
\alias{connect_search_contact_flow_modules}
\title{Searches the flow modules in an Amazon Connect instance, with optional
filtering}
\usage{
connect_search_contact_flow_modules(
  InstanceId,
  NextToken = NULL,
  MaxResults = NULL,
  SearchFilter = NULL,
  SearchCriteria = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can find the instance
ID in the Amazon Resource Name (ARN) of the instance.}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{MaxResults}{The maximum number of results to return per page.}

\item{SearchFilter}{Filters to be applied to search results.}

\item{SearchCriteria}{The search criteria to be used to return flow modules.

The \code{name} and \code{description} fields support "contains" queries with a
minimum of 2 characters and a maximum of 25 characters. Any queries with
character lengths outside of this range will result in invalid results.}
}
\description{
Searches the flow modules in an Amazon Connect instance, with optional filtering.

See \url{https://www.paws-r-sdk.com/docs/connect_search_contact_flow_modules/} for full documentation.
}
\keyword{internal}
