% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my_loadings_sorter.R
\name{my_loadings_sorter}
\alias{my_loadings_sorter}
\title{Sorts loadings from exploratory factor analysis.}
\usage{
my_loadings_sorter(
  fit,
  sort_type = "largest_loading",
  nchar = 40,
  return_blocks = FALSE,
  showlatentcor = TRUE,
  itemLabels = NULL
)
}
\arguments{
\item{fit}{the fitted object from the \code{psych::fa()} function}

\item{sort_type}{how to sort the loadings. One of:
\itemize{
  \item "largest_loading": sorts items by the largest loading
  \item "largest_loading_but_first": sorts items by the largest loading, ignoring the loading on the first factor
  \item "first": sorts items by the largest loading on the first factor
}}

\item{nchar}{the limit for the number of characters to display for the item
label}

\item{return_blocks}{whether to return the block number that corresponds to
each item}

\item{showlatentcor}{whether or not to print the intercorrelation among the
latent factors (only possible for models with an oblique rotation)}

\item{itemLabels}{a vector of the item labels}
}
\value{
Sorted loadings from exploratory factor analysis model.
}
\description{
Sorts items' loadings based on their loadings from exploratory factor
analysis fit with the \code{psych::fa()} function.
}
\details{
Adapted from code by Philipp Doebler (doebler@statistik.tu-dortmund.de).
}
\concept{factor analysis}
