% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.irradiance.r
\name{split_irradiance}
\alias{split_irradiance}
\title{Energy or photon irradiance for split spectrum regions}
\usage{
split_irradiance(
  w.length,
  s.irrad,
  cut.w.length = range(w.length),
  unit.out = getOption("photobiology.base.unit", default = "energy"),
  unit.in = "energy",
  scale = "absolute",
  check.spectrum = TRUE,
  use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges", default = NULL)
)
}
\arguments{
\item{w.length}{numeric Vector of wavelengths [\eqn{nm}].}

\item{s.irrad}{numeric vector of spectral irradiances in
[\eqn{W\,m^{-2}\,nm^{-1}}{W m-2 nm-1}] or
[\eqn{mol\,s^{-1}\,sm^{-2}\,nm^{-1}}{mol s-1 m-2 nm-1}] as indicated by the
argument pased to \code{unit.in}.}

\item{cut.w.length}{numeric Vector of wavelengths [\eqn{nm}].}

\item{unit.out, unit.in}{character Allowed values \code{"energy"}, and
\code{"photon"}, or its alias \code{"quantum"}.}

\item{scale}{a character A string indicating the scale used for the returned
values (\code{"absolute"}, \code{"relative"} or \code{"percent"}).}

\item{check.spectrum}{logical Flag indicating whether to sanity check input data,
default is \code{TRUE}.}

\item{use.cached.mult}{logical Flag indicating whether multiplier values should be
cached between calls.}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}
}
\value{
A numeric vector of irradiances with no change in scale factor if
  \code{scale == "absolute"}, [\eqn{W\,m^{-2}}{W m-2}] or
  [\eqn{mol\,s^{-1}\,sm^{-2}}{mol s-1 m-2}] depending on the argument passed
  to \code{unit.out} or relative values (as fraction of one if \code{scale ==
  "relative"} or percentages if \code{scale == "percent"} of photons or
  energy depending on the argument passed to \code{unit.out}.
}
\description{
This function returns the energy or photon irradiance for a series of
contiguous wavebands from a radiation spectrum. The returned values can be
either absolute or relative to their sum.
}
\note{
The last three parameters control speed optimizations. The defaults
  should be suitable in most cases. If you set \code{check.spectrum=FALSE}
  then you should call \code{\link{check_spectrum}} at least once for your
  spectrum before using any of the other functions. If you will use
  repeatedly the same SWFs on many spectra measured at exactly the same
  wavelengths you may obtain some speed up by setting
  \code{use.cached.mult=TRUE}. However, be aware that you are responsible for
  ensuring that the wavelengths are the same in each call, as the only test
  done is for the length of the \code{w.length} vector.
}
\examples{
with(sun.data,
      split_irradiance(w.length, s.e.irrad,
                       cut.w.length = c(300, 400, 500, 600, 700),
                       unit.out = "photon"))
}
\concept{split a spectrum into regions functions}
