% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{visualiseQTLeffects}
\alias{visualiseQTLeffects}
\title{Visualise QTL homologue effects around a QTL position}
\usage{
visualiseQTLeffects(
  IBD_list,
  Phenotype.df,
  genotype.ID,
  trait.ID,
  linkage_group,
  LOD_data,
  cM_range = NULL,
  col.pal = c("purple4", "white", "seagreen"),
  point.density = 50,
  zero.sum = FALSE,
  allelic_interaction = FALSE,
  exploreQTL_output = NULL,
  return_plotData = FALSE
)
}
\arguments{
\item{IBD_list}{List of IBD probabilities}

\item{Phenotype.df}{A data.frame containing phenotypic values}

\item{genotype.ID}{The colname of \code{Phenotype.df} that contains the population identifiers (F1 names) (must be a colname of \code{Phenotype.df})}

\item{trait.ID}{The colname of \code{Phenotype.df} that contains the response variable to use in the model (must be a colname of \code{Phenotype.df})}

\item{linkage_group}{Numeric identifier of the linkage group being tested, based on the order of \code{IBD_list}.
Only a single linkage group is allowed.}

\item{LOD_data}{Output of \code{\link{QTLscan}} function}

\item{cM_range}{If required, the plotting region can be restricted to a specified range of centiMorgan positions
(provided as a vector of start and end positions).}

\item{col.pal}{Vector of colours to use in the visualisations (it is best to provide two or three colours for simplicity). By default,
effects will be coloured from purple to green through white.}

\item{point.density}{Parameter to increase the smoothing of homologue effect tracks}

\item{zero.sum}{How allele substitution effect should be defined. If \code{FALSE} (by default), the effect of each homologue
is computed relative to the overall phenotypic mean, otherwise contrasts (against offspring without the inherited homologue) are used.}

\item{allelic_interaction}{By default \code{FALSE}, in which case the additive effects of parental alleles are visualised. If \code{TRUE}, a plot of
the mean effect of combinations of parental alleles is visualised instead. \code{exploreQTL_output} is required in this case.}

\item{exploreQTL_output}{If \code{allelic_interaction = TRUE}, the output of the function \code{\link{exploreQTL}} must be provided.}

\item{return_plotData}{Logical, by default \code{FALSE}. If \code{TRUE}, plot data is returned, otherwise \code{NULL}.}
}
\value{
The estimated effects of the homologues, used in the visualisation
}
\description{
Function to visualise the effect of parental homologues around a QTL peak across the population.
}
\examples{
data("IBD_4x","BLUEs.pheno","qtl_LODs.4x")
visualiseQTLeffects(IBD_list = IBD_4x,
                    Phenotype.df = BLUEs.pheno,
                    genotype.ID = "Geno",
                    trait.ID = "BLUE",
                    linkage_group = 2,
                    LOD_data = qtl_LODs.4x)
}
